(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     95392,       2749]*)
(*NotebookOutlinePosition[     97277,       2804]*)
(*  CellTagsIndexPosition[     97175,       2797]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[StyleBox["Fundamentos Pr\[AAcute]ctica 1. Asignaci\[OAcute]n y \
asignaci\[OAcute]n diferida. Listas y reglas de sustituci\[OAcute]n. \
Localizaci\[OAcute]n de variables. Gr\[AAcute]ficas y primitivas \
gr\[AAcute]ficas.",
  FontSize->24]], "Title"],

Cell["\<\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Universidad de Granada\
\>", "Author",
  TextAlignment->Left,
  FontSize->12],

Cell[CellGroupData[{

Cell[TextData[{
  "Los comandos de asignaci\[OAcute]n (",
  Cell[BoxData[
      \(TraditionalForm\` = \)]],
  ") y de asignaci\[OAcute]n diferida (",
  Cell[BoxData[
      \(TraditionalForm\` := \)]],
  ")"
}], "Section"],

Cell[TextData[{
  "En ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " el s\[IAcute]mbolo de igualdad (=) es la forma usual de escribir el \
comando \"",
  StyleBox["Set[ ]",
    FontWeight->"Bold"],
  "\" (l\[EAcute]ase ",
  StyleBox["atribuye",
    FontSlant->"Italic"],
  " o ",
  StyleBox["asigna",
    FontSlant->"Italic"],
  "). As\[IAcute] \"",
  StyleBox["expr1=expr2",
    FontWeight->"Bold"],
  "\" y \"",
  StyleBox["Set[expr1,expr2]",
    FontWeight->"Bold"],
  "\" son dos formas de decirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que eval\[UAcute]e ",
  StyleBox["inmediatamente",
    FontSlant->"Italic"],
  " ",
  StyleBox["expr2",
    FontWeight->"Bold"],
  " y el resultado de esta operaci\[OAcute]n lo asigne en adelante al s\
\[IAcute]mbolo ",
  StyleBox["expr1",
    FontWeight->"Bold"],
  ". Es importante distinguir entre el comando de asignaci\[OAcute]n \
inmediata (=) y el comando de asignaci\[OAcute]n diferida (:=) cuyo nombre es \
\"",
  StyleBox["SetDelayed[ ]",
    FontWeight->"Bold"],
  "\". Cuando escribimos \"",
  StyleBox["expr1 ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\` := \)],
    FontWeight->"Bold"],
  StyleBox[" expr2\"",
    FontWeight->"Bold"],
  " ",
  StyleBox["le estamos diciendo a", "TI",
    FontSlant->"Plain"],
  StyleBox[" ", "TI"],
  StyleBox["Mathematica", "TI",
    FontSlant->"Italic"],
  " que asigne \"",
  StyleBox["expr1",
    FontWeight->"Bold"],
  "\" al valor diferido de \"",
  StyleBox["expr2",
    FontWeight->"Bold"],
  "\" pero \"",
  StyleBox["expr2",
    FontWeight->"Bold"],
  "\" ",
  StyleBox[
  "no se eval\[UAcute]a inmediatamente sino que para ello hay que llamar a",
    FontSlant->"Italic"],
  " \"",
  StyleBox["expr1",
    FontWeight->"Bold"],
  "\" ",
  StyleBox["y cada vez que lo hacemos",
    FontSlant->"Italic"],
  " \"",
  StyleBox["expr2",
    FontWeight->"Bold"],
  "\" ",
  StyleBox["se eval\[UAcute]a de nuevo",
    FontSlant->"Italic"],
  ". Para que entiendas bien la diferencia, en el siguiente ejemplo uso el \
comando \"",
  StyleBox["Random[ ]",
    FontWeight->"Bold"],
  "\" que proporciona un n\[UAcute]mero aleatorio entre 0 y 1. Cada vez que \
ejecutas el comando obtienes (salvo rara casualidad) un n\[UAcute]mero \
distinto. Compru\[EAcute]balo."
}], "Text"],

Cell[BoxData[{
    \(Random[]\), 
    \(Random[]\), 
    \(Random[]\)}], "Input"],

Cell["\<\
Asignamos ahora el s\[IAcute]mbolo \"aleatorio1\" a una ejecuci\[OAcute]n \
inmediata del comando Random[ ]. Dicho comando se ejecutar\[AAcute] y el \
resultado obtenido ser\[AAcute] en adelante el valor de \"aleatorio1\".\
\>", "Text"],

Cell[BoxData[
    \(aleatorio1 = Random[]\)], "Input"],

Cell[BoxData[
    \(aleatorio1\)], "Input"],

Cell["\<\
Hacemos ahora una asignaci\[OAcute]n diferida del s\[IAcute]mbolo \
\"aleatorio2\" al comando Random[ ]. El comando Random[ ] no ser\[AAcute] \
evaluado. Para evaluarlo deberemos invocar al s\[IAcute]mbolo \"aleatorio2\" \
y cada vez que lo hagamos se ejecutar\[AAcute] de nuevo dicho comando por lo \
que el valor de \"aleatorio2\" ser\[AAcute] diferente cada vez que lo \
llamemos.\
\>", "Text"],

Cell[BoxData[
    \(aleatorio2 := Random[]\)], "Input"],

Cell[BoxData[{
    \(aleatorio2\), 
    \(aleatorio2\)}], "Input"],

Cell[TextData[{
  "Habr\[AAcute]s observado que cuando se usa el comando de \
asignaci\[OAcute]n diferida ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " no presenta ninguna salida en pantalla. Eso es debido a que dicho \
comando, al igual que otros, tiene salida Null  que es un s\[IAcute]mbolo \
usado por ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para indicar la ausencia de una expresi\[OAcute]n o resultado como salida \
en pantalla. Cuando un comando tiene salida Null no se imprime nada en \
pantalla."
}], "Text"],

Cell["\<\
Para definir una funci\[OAcute]n puedes usar la asignaci\[OAcute]n inmediata \
y tambi\[EAcute]n la asignaci\[OAcute]n diferida. Muchas veces no tiene mayor \
importancia cu\[AAcute]l de las dos uses pero a veces s\[IAcute] que la \
tiene. Observa.\
\>", "Text"],

Cell[BoxData[{
    \(f[x_] = N[x, 30]\  (*\ 
      aproximaci\[OAcute]n\ decimal\ de\ x\ con\ 30\ d\[IAcute]gitos\ 
        significativos\ *) \), 
    \(f[Pi]\)}], "Input"],

Cell[TextData[{
  "Est\[AAcute] claro lo que ha pasado. Al definir f[x] con la asignaci\
\[OAcute]n inmediata se eval\[UAcute]a enseguida el comando N[x,30] y, como x \
no es una cantidad num\[EAcute]rica, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " da como respuesta el propio x que es lo que de aqu\[IAcute] en adelante ",
  
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " interpretar\[AAcute] como f[\"deloquesea\"]."
}], "Text"],

Cell[BoxData[{
    \(Clear[f]\), 
    \(f[x_] := N[x, 30]\), 
    \(f[Pi]\)}], "Input"],

Cell["\<\
Ahora hemos definido f[x] con la asignaci\[OAcute]n diferida por lo que el \
comando N[x,30] no se eval\[UAcute]a hasta que se llama a la funci\[OAcute]n. \
\
\>", "Text"],

Cell["\<\
Como estrategia general, es conveniente usar la asignaci\[OAcute]n diferida \
para definir funciones pero hay algunos casos importantes como, por ejemplo, \
para definir derivadas, en los que es preferible usar la asignaci\[OAcute]n \
directa. Vamos a verlo.\
\>", "Text"],

Cell[TextData[{
  "Como ya sabes, es muy f\[AAcute]cil representar las derivadas de primero, \
segundo y tercer orden de una funci\[OAcute]n de una variable. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " lo hace igual que t\[UAcute]. Compru\[EAcute]balo."
}], "Text"],

Cell[BoxData[{
    \(f[x_] := x^4\  + Sin[x^2]\), 
    \(\(f'\)[x]\  (*\ 
      para\ escribir\ '\ debes\ usar\ la\ tecla\ junto\ al\ cero\ *) \), 
    \(\(\(f'\)'\)[x]\), 
    \(\(\(\(f'\)'\)'\)[x]\)}], "Input"],

Cell[TextData[{
  "Por tanto, definida una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f[x]\)]],
  " de una variable ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " sabe derivarla y no necesitas definir aparte su derivada ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\ '\)[x]\)]],
  ". Para derivadas de orden mayor que tres se usa el comando \"D[f[x],{x,n}]\
\" que proporciona la derivada n-\[EAcute]sima. Hay una sutileza que debes \
tener en cuenta al definir derivadas. El siguiente ejemplo la pone de \
manifiesto."
}], "Text"],

Cell[BoxData[{
    \(Clear[f]\), 
    \(f[x_] := x^2*Tan[x]\), 
    \(h[x_] := D[f[x], {x, 5}]\), 
    \(h[3]\)}], "Input"],

Cell[TextData[{
  "Al definir h[x] con una igualdad diferida (:=) lo que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ha almacenado como definici\[OAcute]n de h[x] ",
  StyleBox["no",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es la derivada quinta de ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(x\^2\),
            "TraditionalForm"], \(Tan[x]\)}], TraditionalForm]]],
  " sino el comando ",
  Cell[BoxData[
      \(TraditionalForm\`"D[f[x], {x, 5}]"\)]],
  "  pero dicho comando ",
  StyleBox["no",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " se ha ejecutado pues se trata de una ",
  StyleBox["asignaci\[OAcute]n diferida",
    FontSlant->"Italic"],
  " por lo que dicho comando se ejecuta ",
  StyleBox["despu\[EAcute]s",
    FontSlant->"Italic"],
  " de que se llama a la funci\[OAcute]n h[x]. Por eso cuando escribes h[3] \
lo que est\[AAcute]s diciendo a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es que derive f[3] respecto a la variable 3 cinco veces y, claro est\
\[AAcute], 3 no es una variable v\[AAcute]lida para derivar. Naturalmente, \
esto se arregla definiendo h[x] con la asignaci\[OAcute]n inmediata (=)."
}], "Text"],

Cell[BoxData[{
    \(Clear[f, h]\), 
    \(f[x_] := x^2*Tan[x]\), 
    \(h[x_] = D[f[x], {x, 5}]; \nh[3]\)}], "Input"],

Cell[TextData[{
  "La diferencia est\[AAcute] en que ahora ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ejecuta inmediatamente el comando ",
  "D[f[x], {x, 5}] y su resultado lo asigna a h[x]. "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Listas", "Section"],

Cell[TextData[{
  "En ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " una lista es cualquier expresi\[OAcute]n que empiece con \"{\" y termine \
con \"}\". Ejemplos de listas son {1,2,3}, {Cos[x],Sin[y]}, {a,{b,c}}, \
{{1,2},{3,4}}. Una lista es realmente un vector (cuyos elementos pueden ser \
de muy variada naturaleza) por eso el orden en que se escriben sus elementos \
es importante."
}], "Text"],

Cell[BoxData[
    \(\({1, 2} == {2, 1}\  (*\ son\ listas\ distintas\ *) \)\)], "Input"],

Cell["\<\
Otra forma de escribir listas es usando el comando List[elementos].\
\>", "Text"],

Cell[BoxData[
    \(List[a, 1, b, 2]\)], "Input"],

Cell["\<\
Los comandos que se usan con mayor frecuencia para generar listas son Table[ \
] y Range[ ].\
\>", "Text"],

Cell["\<\
Table[expr, {k}] genera una lista con k copias de expr. 
Table[expr, {i, imax}] genera una lista de los valores de expr cuando i \
recorre los valores 1,2,... hasta imax. 
Table[expr, {i, imin, imax}] genera una lista de los valores de expr cuando i \
recorre los valores imin, imin+1,... hasta llegar sin exceder imax. Los \
valores imin, imax pueden o no ser enteros.
Table[expr, {i, imin, imax, inc}] igual que el anterior pero con incrementos \
iguales a inc. 
Table[expr, {i, imin, imax}, {j, jmin, jmax}, \[Ellipsis] ] produce una lista \
de listas (una lista anidada). Para cada valor del \[IAcute]ndice i se \
recorren todos los valores del \[IAcute]ndice j.
Range[k] genera una lista con los primeros k enteros positivos.
Range[a, b] genera una lista que empieza en a con incrementos de una unidad \
hasta llegar a b sin excederlo. Los n\[UAcute]meros a y b pueden o no ser \
enteros.
Range[a, b, inc]  igual que el anterior pero con incrementos iguales a inc. \
\
\>", "Text"],

Cell[BoxData[{
    \(Table[Sin[x], {3}]\), 
    \(Table[2^i, {i, 6}]\), 
    \(Table[i^2, {i, 3, 7}]\), 
    \(Table[i^2, {i, 3.5, 7}]\), 
    \(Table[i^2, {i, 3.5, 7, 0.5}]\), 
    \(Table[n^m, {m, 2}, {n, 3.5, 7, 0.5}]\), 
    \(Range[5]\), 
    \(Range[2.7, 9]\), 
    \(Range[2.7, 9,  .8]\)}], "Input"],

Cell["\<\
Cuando tengas que trabajar con listas de muchos elementos el comando Range[ ] \
suele ser m\[AAcute]s r\[AAcute]pido que Table[ ].\
\>", "Text"],

Cell[BoxData[{
    \(\(Timing[Table[i, {i, 200000}]]\)[\([1]\)]\  (*\ 
      tiempo\ que\ tarda\ Table[\ ]\ en\ generar\ los\ primero\ doscientos\ 
        mil\ n\[UAcute]meros\ *) \), 
    \(\(Timing[Range[200000]]\)[\([1]\)]\n (*\ 
      tiempo\ que\ tarda\ Range[\ ]\ en\ generar\ los\ primero\ doscientos\ 
        mil\ n\[UAcute]meros\ *) \)}], "Input"],

Cell[TextData[{
  "Una particularidad de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " extraordinariamente \[UAcute]til es que casi todas las funciones pueden \
trabajar con listas. Aqu\[IAcute] tienes unos ejemplos."
}], "Text"],

Cell[BoxData[{
    \(Sin[Range[1. , 2,  .1]]\), 
    \(Range[1, 7]^2\), 
    \(1/Range[1, 7]\), 
    \({Range[1, 3], Range[4, 7]}^2\)}], "Input"],

Cell[TextData[{
  "En general, para aplicar una funci\[OAcute]n a los elementos de una lista, \
se usa el comando Map[funcion,lista] donde \"funcion\" debe ser el ",
  StyleBox["nombre",
    FontSlant->"Italic"],
  " de la funci\[OAcute]n."
}], "Text"],

Cell[BoxData[{
    \(Map[funcion, {a, b, c}]\), "\n", 
    \(Map[1/x, {1, 2, 3}]\  (*\ no\ es\ correcto\ *) \), "\n", 
    \(inverso[x_] := 1/x\), "\n", 
    \(Map[inverso, {1, 2, 3}]\)}], "Input"],

Cell["\<\
Con frecuencia es preciso sumar o multiplicar los elementos de una lista. \
Esto puede hacerse con los comandos Apply[Plus,lista] y Apply[Times,lista].\
\>", "Text"],

Cell[BoxData[{
    \(Apply[Plus, Range[1, 100]]\  (*\ 
      calculamos\ la\ suma\ de\ los\ primeros\ 100\ n\[UAcute]meros\ *) \), 
    \(Apply[Times, Range[1, 10]]\  (*\ 
      calculamos\ el\ producto\ de\ los\ primeros\ 10\ n\[UAcute]meros\ *) 
      \)}], "Input"],

Cell["\<\
A veces interesa controlar el lugar en que se aplica una funci\[OAcute]n. Aqu\
\[IAcute] tienes un ejemplo.\
\>", "Text"],

Cell[BoxData[{
    \(Apply[Plus, {{1, 2}, {3, 4}}]\  (*\ 
      suma\ las\ dos\ listas\ elemento\ a\ elemento\ *) \), "\
\[IndentingNewLine]", 
    \(Apply[Plus, {{1, 2}, {3, 4}}, 1]\  (*\ 
      suma\ los\ elementos\ de\ cada\ una\ de\ las\ listas\ *) \)}], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5. 0 y siguientes tiene el comando Total[lista] que calcula la suma de \
todos los elementos de una lista."
}], "Text"],

Cell[BoxData[
    \(\(\(Total[Range[100]]\)\(\ \)\( (*\ 
      no\ funciona\ en\ Mathematica\ 3.0\ *) \)\)\)], "Input"],

Cell["\<\
El comando Length[lista] proporciona el n\[UAcute]mero de elementos de una \
lista.\
\>", "Text"],

Cell[BoxData[{
    \(Length[Range[23]]\), 
    \(Length[Table[Range[k], {k, 7}]]\)}], "Input"],

Cell["\<\
Una matriz es una lista cuyos elementos son listas simples (las filas) de \
igual longitud (n\[UAcute]mero de columnas).\
\>", "Text"],

Cell[BoxData[
    \(\(A = Table[\(-i\)*j + 2  j, {i, 3}, {j, 4}]\  (*\ 
      una\ matriz\ de\ 3\ filas\ y\ 4\ columnas\ *) \)\)], "Input"],

Cell["Podemos escribir A en forma matricial.", "Text"],

Cell[BoxData[
    \(\(\(MatrixForm[A]\ \) (*\ 
      esto\ puede\ hacerse\ tambi\[EAcute]n\ en\ la\ forma\ 
        "\<A // MatrixForm\>"\ *) \)\)], "Input"],

Cell["\<\
Podemos sumar y multiplicar listas de igual longitud. El producto de listas \
se hace elemento a elemento, es decir, se multiplican los elementos que \
ocupan el mismo lugar en cada una de las listas.\
\>", "Text"],

Cell[BoxData[{
    \({a, b, c} + {x, y, z}\  (*\ suma\ de\ listas\ *) \), 
    \({a, b, c} {x, y, z}\  (*\ 
      producto\ de\ listas\ elemento\ a\ elemento\ *) \), 
    \({{a, b}, {1, 2, 3}} {{2, 3}, {x, y, z}}\  (*\ 
      producto\ de\ listas\ elemento\ a\ elemento\ *) \)}], "Input"],

Cell["\<\
Para multiplicar dos matrices con las dimensiones apropiadas se escribe \".\" \
entre ellas dos. Para multiplicar matrices debes representarlas como listas y \
no usar la forma matricial MatrixForm[ ]. En general, para hacer \
c\[AAcute]lculos en los que intervengan matrices hay que representar dichas \
matrices como listas y no usar la forma MatrixForm[ ]. El comando MatrixForm[ \
] solamente sirve para representar una matriz en la forma usual pero no sirve \
para hacer c\[AAcute]lculos.\
\>", "Text"],

Cell[BoxData[
    \(B = Table[i*j - 2  j, {i, 4}, {j, 3}]\)], "Input"],

Cell[BoxData[
    \(MatrixForm[B]\)], "Input"],

Cell[BoxData[
    \(M = A . B\)], "Input"],

Cell[BoxData[
    \(MatrixForm[M]\)], "Input"],

Cell["Observa la diferencia.", "Text"],

Cell[BoxData[{
    \(M\ M\  (*\ producto\ como\ listas\ M*M = M^2\ *) \), 
    \(M . M\  (*\ producto\ matricial\ *) \), 
    \({a, b, c} {x, y, z}\  (*\ producto\ como\ listas\ *) \), 
    \({a, b, c} . {x, y, z}\  (*\ producto\ escalar\ de\ dos\ vectores\ *) 
      \)}], "Input"],

Cell["\<\
Para indicar el elemento que ocupa el lugar k en una lista se usa la sintaxis \
\"lista[[k]]\".\
\>", "Text"],

Cell[BoxData[{
    \({a, b, c, d}[\([2]\)]\  (*\ segundo\ elemento\ de\ la\ lista\ *) \), 
    \(A[\([1]\)]\  (*\ primer\ elemento\ de\ la\ lista\ *) \)}], "Input"],

Cell["\<\
En una lista de listas se usa la sintaxis \"lista[[i,j]]\" para seleccionar \
el elemento que ocupa el lugar i de la lista (la fila) y dentro de \[EAcute]l \
el que ocupa el lugar j (la columna).\
\>", "Text"],

Cell[BoxData[
    \(A[\([1, 4]\)]\)], "Input"],

Cell["\<\
El comando Sum[f[k],{k,kmin,kmax}] que suma los valores de f[k] desde k=kmin \
hasta k=kmax puede usarse para sumar elementos de una lista. Para calcular el \
producto podemos usar el comando Product[f[k],{k,kmin,kmax}]. Todo lo que hay \
que hacer es sustituir f[k] por el k-\[EAcute]simo elemento de la lista: \
Sum[lista[[k]],{k,kmin,kmax}] o Product[lista[[k]],{k,kmin,kmax}].\
\>", "Text"],

Cell["\<\
El comando Reverse[lista] invierte el orden de los elementos de la lista.\
\>", "Text"],

Cell[BoxData[
    \(Reverse[{a, b, c, d, e}]\)], "Input"],

Cell["\<\
El comando Transpose[listadelistas] intercambia los primeros dos niveles en \
\"listadelistas\". Cuando se trata de una matriz cambia filas por columnas. \
Las listas deben ser de igual longitud.\
\>", "Text"],

Cell[BoxData[
    \(Transpose[A]\)], "Input"],

Cell[BoxData[
    \(% // MatrixForm\)], "Input"],

Cell[BoxData[
    \(Transpose[{{{1, 2}, {3, 4}}, {5, 6}, {7, 8}}]\)], "Input"],

Cell["\<\
El comando Sort[lista] ordena los elementos de una lista. Last[lista] y \
First[lista] nos dan el \[UAcute]ltimo y el primer elemento de una lista. \
Max[lista] y Min[lista] nos dan el m\[AAcute]ximo y el m\[IAcute]nimo \
elemento de una lista num\[EAcute]rica.\
\>", "Text"],

Cell[BoxData[{
    \(Sort[{u, x, v, c, a, f, e}]\ \  (*\ 
      ordena\ lexicogr\[AAcute]ficamente\ *) \), 
    \(Sort[{0.5, 0.12, 0.23, 0.67, 0.765, 0.07}]\ \  (*\ 
      ordena\ de\ menor\ a\ mayor\ *) \), 
    \(Last[{0.5, 0.12, 0.23, 0.67, 0.765, 0.07}]\ \  (*\ 
      \[UAcute]ltimo\ elemento\ *) \), 
    \(First[{u, x, v, c, a, f, e}]\ \ \  (*\ primer\ elemento\ *) \), 
    \(Max[{0.5, 0.12, 0.23, 0.67, 0.765, 0.07}]\ \ \), 
    \(Min[{0.5, 0.12, 0.23, 0.67, 0.765, 0.07}]\ \)}], "Input"],

Cell[BoxData[
    \(Map[Sort, {{3, 2, 1}, {6, 4, 7}}]\)], "Input"],

Cell[TextData[{
  "Una operaci\[OAcute]n importante es la de seleccionar elementos en una \
lista lo que se hace con el comando Select[lista,criterio]. Hay que definir \
previamente el criterio de selecci\[OAcute]n el cual debe ser una funci\
\[OAcute]n boleana. Para definir esa funci\[OAcute]n es obligado quen uses la \
asignaci\[OAcute]n diferida porque de no hacerlo ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tratar\[IAcute]a de evaluar inmediatamente la expresi\[OAcute]n de la \
derecha lo que dar\[IAcute]a lugar a un error. Aqu\[IAcute] tienes algunos \
ejemplos."
}], "Text"],

Cell[BoxData[{
    \(mayorque7[x_] := x > 7\), 
    \(Select[Range[\(-2\), 10], mayorque7]\)}], "Input"],

Cell[BoxData[{
    \(multiplodetres[x_] := IntegerQ[x/3]\  (*\ 
      IntegerQ[z]\ es\ True\ si\ z\ es\ entero\ y\ False\ en\ otro\ 
        caso . \ Observa\ que\ no\ podemos\ usar\ la\ asignaci\[OAcute]n\ 
        inmediata\ *) \), 
    \(Select[Range[\(-15\), 15], multiplodetres]\  (*\ 
      seleccionamos\ los\ m\[UAcute]ltiplos\ de\ 3\ *) \)}], "Input"],

Cell[TextData[{
  "A veces podemos necesitar un criterio de selecci\[OAcute]n que depende de \
un par\[AAcute]metro.  Por ejemplo, sup\[OAcute]n que queremos seleccionar  \
en una lista los n\[UAcute]meros ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " con la propiedad de que ",
  Cell[BoxData[
      \(TraditionalForm\`k \[LessEqual] x < k + 1\)]],
  " y que eso queremos hacerlo para valores de ",
  Cell[BoxData[
      \(TraditionalForm\`k = 0, 1, 2,  ... , 9. \)]],
  " Podr\[IAcute]amos definir diez criterios de selecci\[OAcute]n de la forma \
\"comprendidoentre2y3",
  Cell[BoxData[
      \(TraditionalForm\`\([x_]\) := 2 \[LessEqual] x < 3\)]],
  "\" y aplicar dichos criterios de uno en uno para seleccionar los elementos \
de la lista comprendidos en cada uno de esos intervalos. Pero es mejor \
hacerlo como sigue."
}], "Text"],

Cell[BoxData[{
    \(milista = Table[Random[Real, {0, 10}], {50}]\ ;  (*\ 
      generamos\ una\ lista\ con\ 50\ n\[UAcute]meros\ aleatorios\ reales\ \
comprendidos\ entre\ 0\ y\ 10\ *) \n\(comprendidoentre[k_]\)[x_] := 
      k \[LessEqual] 
        x < \(\(k\)\(+\)\(1\)\(\ \)\( (*\ 
            as\[IAcute]\ definimos\ de\ golpe\ todos\ los\ criterios\ de\ \
selecci\[OAcute]n, \ 
            pues\ la\ funci\[OAcute]n\ "\<comprendidoentre[k]\>"\ elige\ los\ \
n\[UAcute]meros\ comprendidos\ entre\ k\ y\ k + 1\ *) \)\)\), "\n", 
    \(Table[Select[milista, comprendidoentre[k]], {k, 0, 9}]\), "\n", 
    \(Clear[milista, comprendidoentre]\)}], "Input"],

Cell["\<\
Las funciones boleanas OddQ, EvenQ, IntegerQ, NumberQ, VectorQ, PrimeQ, \
NumericQ, Positive, Negative pueden usarse como criterios de \
selecci\[OAcute]n. \
\>", "Text"],

Cell[BoxData[{
    \(Select[Table[3*k, {k, 15}], EvenQ]\  (*\ 
      selecciona\ los\ n\[UAcute]meros\ pares\ *) \), 
    \(Select[Table[3*k, {k, 15}], OddQ]\  (*\ 
      selecciona\ los\ n\[UAcute]meros\ impares\ *) \), 
    \(Select[{1, {2, 3}, a, {c}, d, e}, VectorQ]\  (*\ selecciona\ listas\ *) 
      \), 
    \(Select[Sin[Range[2. , 5. ,  .25]], Positive]\), 
    \(Select[Sin[Range[2. , 5. ,  .25]], Negative]\)}], "Input"],

Cell["\<\
Los comandos Append[lista,elemento] y Prepend[lista,elemento] agregan \
\"elemento\" al final o al principio de \"lista\".\
\>", "Text"],

Cell[BoxData[{
    \(Append[{a, b, c}, 1]\), 
    \(Append[{a, b, c}, {1, 2}]\), 
    \(Prepend[{a, b, c}, 1]\), 
    \(Prepend[{a, b, c}, {1, 2}]\)}], "Input"],

Cell["\<\
Para extraer o eliminar elementos de una lista se usan \
Take[lista,{numero1,numero2}] y Drop[lista,{numero1,numero2}].\
\>", "Text"],

Cell[BoxData[{
    \(Take[{a, b, c, d, e, f}, {2, 4}]\  (*\ 
      extrae\ los\ elmentos\ comprendidos\ entre\ el\ segundo\ y\ el\ cuarto\ 
        ambos\ inclusive\ *) \), 
    \(Take[{a, b, c, d, e, f}, 3]\  (*\ 
      extrae\ los\ primeros\ 3\ elementos\ *) \), 
    \(Take[{a, b, c, d, e, f}, \(-3\)] (*\ 
      extrae\ los\ \[UAcute]ltimos\ 3\ elementos\ *) \)}], "Input"],

Cell[BoxData[{
    \(Drop[{a, b, c, d, e, f}, {2, 4}]\  (*\ 
      elimina\ los\ elmentos\ comprendidos\ entre\ el\ segundo\ y\ el\ cuarto
        \ ambos\ inclusive\ *) \), 
    \(Drop[{a, b, c, d, e, f}, 3]\  (*\ 
      elimina\ los\ primeros\ 3\ elementos\ *) \), 
    \(Drop[{a, b, c, d, e, f}, \(-3\)]\  (*\ 
      elimina\ los\ \[UAcute]ltimos\ 3\ elementos\ *) \ \)}], "Input"],

Cell["\<\
El comando Partition[lista,k] hace una partici\[OAcute]n de \"lista\" en \
sublistas disjuntas de k elementos consecutivos. Si el n\[UAcute]mero de \
elementos de \"lista\" no es m\[UAcute]ltiplo de k los \[UAcute]ltimos \
elementos se eliminan. Partition[lista,k,j] hace una lista con sublistas de k \
elementos consecutivos que empiezan en los elementos de \"lista\" que ocupan \
los lugares 1, j+1, 2j+1,...\
\>", "Text"],

Cell[BoxData[{
    \(Partition[{a, b, c, d, e, f, g}, 2]\), 
    \(Partition[{a, b, c, d, e, f, g}, 3, 2]\), 
    \(Partition[{a, b, c, d, e, f, g}, 4, 1]\)}], "Input"],

Cell["\<\
Un comando que es muy \[UAcute]til para trabajar con listas es el comando \
Flatten[ ] que convierte una lista de listas en una lista.\
\>", "Text"],

Cell[BoxData[
    \(Flatten[{{1, 2, 3}, {4, 5, 6}, {{7, 8}, {9, 10}}}]\)], "Input"],

Cell[TextData[{
  "Con mucha frecuencia hay que aplicar una funci\[OAcute]n de varias \
variables a un vector o a los elementos de una lista cuyos elementos son \
vectores con igual n\[UAcute]mero de elementos que variables tiene la funci\
\[OAcute]n. La dificultad est\[AAcute] en que las funciones en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " conviene definirlas de la forma func[x,y] o func[x,y,z] y as\[IAcute] \
definidas no pueden trabajar directamente sobre vectores de la forma {x,y} o \
{x,y,z}. No es lo mismo f[1,2] que f[{1,2}]. Observa la (importante) \
diferencia."
}], "Text"],

Cell[BoxData[{
    \(\(f[x_, y_] = x + y\^2;\)\), "\[IndentingNewLine]", 
    \({f[{1, 2}], f[1, 2]}\)}], "Input"],

Cell["\<\
El comando Apply[func,expr] es \[UAcute]til para esto: reemplaza la cabeza de \
\"expr\" (Head[expr]) por \"func\". Este comando tambi\[EAcute]n se escribe \
en la forma f@@expr. \
\>", "Text"],

Cell[BoxData[
    \(\(\(Clear[f]\[IndentingNewLine]
    Apply[f, {a, b}]\[IndentingNewLine]
    {Head[{a, b}], Head[f[a, b]]}\)\( (*\ 
      toda\ expresi\[OAcute]n\ en\ Mathematica\ tiene\ una\ cabeza\ Head[
          expresion]\ *) \)\)\)], "Input"],

Cell["\<\
En particular, la funci\[OAcute]n \"func\" en Apply[func,expr] puede ser, \
como hemos visto antes, \"Plus\", o \"Times\". Pero tambi\[EAcute]n puede ser \
cualquier funci\[OAcute]n que definamos nosotros.\
\>", "Text"],

Cell[BoxData[{
    \(Clear[f]\), "\[IndentingNewLine]", 
    \(\(f[x_, y_, z_] := {g[x, y, z], 
          h[x, y, z]};\)\), "\[IndentingNewLine]", 
    \(Apply[f, {a, b, c}]\), "\[IndentingNewLine]", 
    \(Clear[f, g, h]\)}], "Input"],

Cell["\<\
Cuando queremos que nuestra funci\[OAcute]n act\[UAcute]e sobre los elementos \
de una lista hay que especificar el \"nivel\" que dichos elementos ocupan en \
la lista. Apply[func,expr] act\[UAcute]a sobre el nivel 0 de \"expr\" que es \
\"expr\" (es decir, act\[UAcute]a sobre Head[expr]), esta es la \
opci\[OAcute]n por defecto; mientras que Apply[func,expr,posicion] act\
\[UAcute]a sobre los elementos de \"expr\" que ocupan la posici\[OAcute]n \
indicada (es decir, act\[UAcute]a sobre las cabeceras, Head[ ], de dichos \
elementos).\
\>", "Text"],

Cell[BoxData[
    RowBox[{\(Apply[f, {{a, b}, {c, d}, {u, v, w}}]\ \[IndentingNewLine]
      Apply[f, {{a, b}, {c, d}, {u, v, w}}, {1}]\), 
      RowBox[{"(*", " ", 
        RowBox[{
          RowBox[{"se", " ", "aplica", " ", "f", " ", "en", " ", "el", " ", 
            StyleBox["nivel",
              FontSlant->"Italic"], " ", "1", " ", "de", " ", "la", " ", 
            "lista"}], ",", " ", \(es\ decir\), ",", 
          " ", \(a\ los\ elementos\ de\ la\ lista\)}], " ", "*)"}]}]], "Input"],

Cell["\<\
Para saber los elementos que ocupan un determinado nivel en una expresi\
\[OAcute]n puedes usar el comando Level[expr, nivel] cuya salida es una lista \
con los elementos de \"expr\" que ocupan el nivel indicado. \
\>", "Text"],

Cell[BoxData[{
    \(Level[{{a, b}, {c, d}, {u, v, w}}, {0}] (*\ 
      observa\ la\ diferencia\ con\ el\ siguiente\ *) \), \
"\[IndentingNewLine]", 
    \(Level[{{a, b}, {c, d}, {u, v, w}}, {1}] (*\ 
      observa\ la\ diferencia\ con\ el\ anterior\ *) \), \
"\[IndentingNewLine]", 
    \(Level[{{a, b}, {c, d}, {u, v, w}}, {2}]\)}], "Input"],

Cell[TextData[{
  "Como puedes ver, para",
  StyleBox[" Mathematica",
    FontSlant->"Italic"],
  " no es lo mismo \"expr\" que {\"expr\"} que {{\"expr\"}}. "
}], "Text"],

Cell["\<\
Observa las diferencias entre Apply[func,expr] y Map[func, expr].\
\>", "Text"],

Cell[BoxData[{
    \({Map[f, {a, b, c}], Apply[f, {a, b, c}]}\), "\[IndentingNewLine]", 
    \({Map[f, {{a, b}, {c, d}}], Apply[f, {{a, b}, {c, d}}, {1}]}\)}], "Input"],

Cell["\<\
Hay otras formas de hacer esto mismo. Por ejemplo, usando una regla de \
sustituci\[OAcute]n (ver la siguiente secci\[OAcute]n).\
\>", "Text"],

Cell[BoxData[{
    \(\(f[x_, y_] = x^2 + 3  y;\)\), "\[IndentingNewLine]", 
    \(\(lista = {{1, 2}, {3, 4}, {5, 6}, {7, 
            8}};\)\), "\[IndentingNewLine]", 
    \(lista /. {x_?NumericQ, y_?NumericQ} \[Rule] 
        f[x, y]\), "\[IndentingNewLine]", 
    \( (*\ 
      esta\ regla\ de\ sustituci\[OAcute]n\ le\ dice\ a\ Mathematica\ que\ en\
\ la\ lista\ de\ la\ izquierda\ sustituya\ los\ elementos\ de\ la\ forma\ {x, 
          y}\ donde\ x\ e\ y\ son\ n\[UAcute]meros\ por\ f[x, 
          y]\ *) \)}], "Input"],

Cell["Pero lo m\[AAcute]s c\[OAcute]modo es usar Apply[ ].", "Text"],

Cell[BoxData[
    \(Apply[f, lista, {1}]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone de much\[IAcute]simos comandos para trabajar con listas. Uno de \
los m\[AAcute]s \[UAcute]tiles con el que acabamos esta secci\[OAcute]n es el \
comando Outer[f, lista1, lista2] donde f puede ser una funci\[OAcute]n o un \
comando."
}], "Text"],

Cell[BoxData[{
    \(Clear[f]\), "\[IndentingNewLine]", 
    \(Outer[f, {a, b, c}, {1, 2, 3, 4}]\)}], "Input"],

Cell[BoxData[
    \(Outer[List, {a, b, c}, {u, v, x}]\)], "Input"],

Cell[BoxData[
    \(Transpose[%]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Reglas de sustituci\[OAcute]n y reglas de sustituci\[OAcute]n diferidas. \
Operador de sustituci\[OAcute]n\
\>", "Section"],

Cell["\<\
Cuando queremos sustituir en una expresi\[OAcute]n un s\[IAcute]mbolo por un \
valor o por otro s\[IAcute]mbolo puede no ser conveniente usar el comando de \
asignaci\[OAcute]n (=) porque dicho comando atribuye un valor fijo \"para \
siempre\". El siguiente ejemplo explica lo que quiero decirte.\
\>", "Text"],

Cell[BoxData[{
    \(polixy = x*y^2 + 3  x + 4  y\ \), "\n", 
    \( (*\ 
      una\ expresi\[OAcute]n\ algebraica\ en\ la\ que\ intervienen\ dos\ \
variables\ "\<x\>"\ e\ "\<y\>"\ *) \)}], "Input"],

Cell["\<\
Podemos querer sustituir en dicha expresi\[OAcute]n la variable \"x\" por 7. \
Una forma de hacerlo es como sigue.\
\>", "Text"],

Cell[BoxData[
    \(\(\(\(x = 7\)\npolixy\)\(\ \ \ \)\( (*\ 
      polixy\ ha\ cambiado\ *) \)\)\)], "Input"],

Cell[TextData[{
  "El inconveniente de esto es que ya no puedo seguir usando \"x\" como una \
variable. Hay otra forma de proceder m\[AAcute]s c\[OAcute]moda que consiste \
en decirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " \"sustituye x por 7\". Para ello necesitas DOS comandos: una ",
  StyleBox["regla de sustituci\[OAcute]n",
    FontWeight->"Bold"],
  " (",
  Cell[BoxData[
      \(TraditionalForm\`x -> 7\)]],
  ") y el ",
  StyleBox["comando de sustituci\[OAcute]n",
    FontWeight->"Bold"],
  " ( ",
  StyleBox["/.",
    FontWeight->"Bold"],
  " ). Una",
  StyleBox[" regla de sustituci\[OAcute]n inmediata",
    FontWeight->"Bold"],
  " es un comando de la forma \"",
  Cell[BoxData[
      \(TraditionalForm\`expr1 -> expr2\)],
    FontWeight->"Bold"],
  "\" (que es otra manera de escribir ",
  StyleBox["Rule[expr1,expr2]",
    FontWeight->"Bold"],
  ") que representa una regla que transforma \"",
  StyleBox["expr1",
    FontWeight->"Bold"],
  "\" en \"",
  StyleBox["expr2",
    FontWeight->"Bold"],
  "\". Puedes escribir ",
  Cell[BoxData[
      \(TraditionalForm\` -> \)]],
  " con mejor apariencia tecleando \"Esc",
  Cell[BoxData[
      \(TraditionalForm\` -> \)]],
  "Esc\". Este es el resultado \[Rule]. El operador de sustituci\[OAcute]n \
\"",
  StyleBox["expr /. reglas",
    FontWeight->"Bold"],
  "\" (que es otra manera de escribir ",
  StyleBox["ReplaceAll[expr,reglas]",
    FontWeight->"Bold"],
  ") trata de aplicar una regla o varias reglas ",
  StyleBox["despu\[EAcute]s",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " de evaluar \"",
  StyleBox["expr",
    FontWeight->"Bold"],
  "\". Por ejemplo \"",
  StyleBox["expr1 /. b\[Rule]c",
    FontWeight->"Bold"],
  "\"",
  StyleBox[" ",
    FontWeight->"Bold"],
  "significa que en la expresi\[OAcute]n \"",
  StyleBox["expr1",
    FontWeight->"Bold"],
  "\" ",
  StyleBox["despu\[EAcute]s de ser evaluada",
    FontSlant->"Italic"],
  " todas las apariciones de ",
  StyleBox["b",
    FontWeight->"Bold"],
  " deben ser inmediatamente sustituidas por ",
  StyleBox["c",
    FontWeight->"Bold"],
  ". Observa su uso."
}], "Text"],

Cell[BoxData[
    \(\(\(Clear[x]\ \ \ \  (*\ limpiamos\ el\ s\[IAcute]mbolo\ x\ *) \n
      polixy\ \ \ \ \ \ \ \ \  (*\ 
        polixy\ vuelve\ a\ ser\ lo\ que\ era\ *) \n\(\(polixy /. 
        x \[Rule] 7\)\(\ \ \ \ \)\(\n\)\)\t\t (*\ 
        atribuimos\ a\ x\ el\ valor\ 7\ obteniendo\ igual\ resultado\ que\ \
antes\ *) \npolixy\)\(\ \ \ \ \ \ \ \ \ \)\( (*\ 
      polixy\ no\ ha\ cambiado\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(?x\ \ \ \ \)\( (*\ 
      x\ sigue\ siendo\ una\ variable\ *) \)\)\)], "Input"],

Cell[TextData[{
  " Cuando en un comando del tipo \"",
  StyleBox["expr /. regla",
    FontWeight->"Bold"],
  "\" no puede aplicarse ninguna regla de sustituci\[OAcute]n ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " devuelve \"",
  StyleBox["expr",
    FontWeight->"Bold"],
  "\" sin cambio ninguno."
}], "Text"],

Cell[BoxData[
    \(a + 3  b /. c \[Rule] 2\)], "Input"],

Cell[BoxData[{
    RowBox[{\(2  a + 5  a /. \ 2  a \[Rule] 3\), " "}], "\n", 
    RowBox[{
      RowBox[{"(*", " ", 
        RowBox[{
          StyleBox["primero",
            FontSlant->"Italic"], " ", "se", " ", "eval\[UAcute]a", " ", "la",
           " ", "expresi\[OAcute]n", " ", "por", " ", "lo", " ", "que", " ", 
          "no", " ", "puede", " ", "aplicarse", " ", "la", " ", "regla"}], 
        " ", "*)"}]}]}], "Input"],

Cell[TextData[{
  "Es importante advertir que ",
  StyleBox["el operador de sustituci\[OAcute]n aplica las reglas de sustituci\
\[OAcute]n exactamente una sola vez en cada parte de la expresi\[OAcute]n que \
hay a su izquierda",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(3 \( x\^2\) \((1 + x + x\^2)\) /. {x\^2 \[Rule] x, 
        x \[Rule] a}\)], "Input"],

Cell[TextData[{
  "Si queremos que se apliquen las reglas de sustituci\[OAcute]n \
repetidamente hasta que la expresi\[OAcute]n de la izquierda permanezca \
invariante debemos usar el comando  \"",
  StyleBox["expr //. reglas",
    FontWeight->"Bold"],
  "\" (que es otra manera de escribir ",
  StyleBox["ReplaceRepeated[expr,reglas]",
    FontWeight->"Bold"],
  "). Observa la diferencia."
}], "Text"],

Cell[BoxData[
    \(3 \( x\^2\) \((1 + x + x\^2)\) //. {x\^2 \[Rule] x, 
        x \[Rule] a}\)], "Input"],

Cell[TextData[{
  "Cuando uses este comando debes ser cuidadoso para no entrar en un bucle \
infinito cosa que ocurrir\[IAcute]a si, por ejemplo, tratas de ejecutar algo \
como  ",
  StyleBox["x", "MR",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["//.", "MR",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["x", "MR",
    FontWeight->"Bold"],
  StyleBox[" \[Rule] ",
    FontWeight->"Bold"],
  StyleBox["x", "MR",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["+", "MR",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["1", "MR",
    FontWeight->"Bold"],
  StyleBox[".", "MR"]
}], "Text"],

Cell["\<\
Si aplicamos una lista de listas de reglas de sustituci\[OAcute]n obtenemos \
como resultado una lista cuyos elementos se obtienen aplicando cada una de \
las reglas de sustituci\[OAcute]n a la expresi\[OAcute]n que hay a la \
izquierda.\
\>", "Text"],

Cell[BoxData[
    \(3 \( x\^2\) 
        Cos[1 + x + x\^2] /. {{x\^2 \[Rule] x}, {x \[Rule] a}}\)], "Input"],

Cell[TextData[{
  "Recuerda que algunos comandos de resoluci\[OAcute]n de ecuaciones como, \
por ejemplo, Solve[ecuaci\[OAcute]n,variable] y \
NSolve[ecuaci\[OAcute]n,variable] tienen como salida una lista cuyos \
elementos son listas de reglas de sustituci\[OAcute]n de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`variable \[Rule] soluci\[OAcute]n\)]],
  ". Por tanto, al aplicar la salida de estos comandos a \"variable\" \
obtenemos una lista con las soluciones: \"variable",
  StyleBox["/.",
    FontWeight->"Bold"],
  "Solve[ecuaci\[OAcute]n,variable]\"."
}], "Text"],

Cell["\<\
Puedes aplicar reglas de sustituci\[OAcute]n a \"patrones\" de forma parecida \
a como se definen funciones. Aqu\[IAcute] tienes dos ejemplos. \
\>", "Text"],

Cell[BoxData[
    \(f[a] + f[a + b] + f[b*c] \((u + v)\) /. f[x_] \[Rule] x^2\)], "Input"],

Cell[BoxData[
    \(\(\(logprod = Log[x_*y_] \[Rule] \ Log[x] + Log[y];  (*\ 
      esta\ regla\ no\ est\[AAcute]\ implementada\ en\ Mathematica\ porque\ \
para\ n\[UAcute]meros\ complejos\ no\ es\ cierta\ en\ general\ *) \n\(\(Log[
        a*b*c]\)\(/.\)\(\ \)\(logprod\)\(\ \)\( (*\ 
        aplica\ una\ sola\ vez\ el\ comando\ de\ sustituci\[OAcute]n\ *) \)\)\
\n
    Log[a*b*c] //. logprod\)\(\ \)\( (*\ 
      aplica\ repetidamente\ el\ comando\ de\ sustituci\[OAcute]n\ *) \
\)\)\)], "Input"],

Cell[TextData[{
  "Al igual que ocurre con la asignaci\[OAcute]n diferida (",
  Cell[BoxData[
      \(TraditionalForm\` := \)]],
  ") tambi\[EAcute]n es posible dar ",
  StyleBox["reglas de sustituci\[OAcute]n diferidas",
    FontWeight->"Bold"],
  " \"",
  StyleBox["expr1",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\` :> \)],
    FontWeight->"Bold"],
  StyleBox["expr2",
    FontWeight->"Bold"],
  "\" (que es otra manera de escribir ",
  StyleBox["RuleDelayed[expr1,expr2]",
    FontWeight->"Bold"],
  "). Puedes escribir ",
  Cell[BoxData[
      \(TraditionalForm\` :> \)]],
  " con mejor apariencia si tecleas \"Esc",
  Cell[BoxData[
      \(TraditionalForm\` :> \)]],
  "Esc\". Este es el resultado \[RuleDelayed]. En el siguiente ejemplo puedes \
apreciar la diferencia entre usar unas u otras."
}], "Text"],

Cell[BoxData[{
    \({x, x, x, x, x} /. x \[Rule] Random[]\ \), "\n", 
    \( (*\ 
      aqu\[IAcute]\ se\ ejecuta\ inmediatamente\ Random[]\ y\ x\ queda\ \
sustituido\ por\ el\ valor\ devuelto\ por\ Random[]\ *) \)}], "Input"],

Cell[BoxData[{
    \({x, x, x, x, 
        x} /. \(\(x\)\(\[RuleDelayed]\)\(\ \)\(Random[]\)\(\ \)\)\), "\n", 
    \( (*\ 
      aqu\[IAcute]\ se\ ejecuta\ Random[]\ cada\ vez\ que\ se\ aplica\ la\ \
regla\ de\ sustituci\[OAcute]n\ y\ en\ cada\ caso\ x\ queda\ sustituido\ por\ \
el\ valor\ devuelto\ por\ Random[]\ *) \)}], "Input"],

Cell[TextData[{
  "Ten en ecuenta que cuando se ejecuta un comando de la forma \"",
  StyleBox["epr1 /. expr2[x_,y_,...]\[Rule]expr3[x,y,...]\"",
    FontWeight->"Bold"],
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " primero eval\[UAcute]a \"",
  StyleBox["expr1",
    FontWeight->"Bold"],
  "\", despu\[EAcute]s eval\[UAcute]a la regla de sustituci\[OAcute]n \"",
  StyleBox["expr2[x_,y_,...]\[Rule]expr3[x,y,...]",
    FontWeight->"Bold"],
  "\" y finalmente realiza la sustituci\[OAcute]n indicada. Por eso cuando en \
la regla \"",
  StyleBox["expr2[x_,y_,...]\[Rule]expr3[x,y,...]",
    FontWeight->"Bold"],
  "\" se realizan operaciones simb\[OAcute]licas",
  StyleBox[",",
    FontSlant->"Italic"],
  " por ejemplo",
  StyleBox[" ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["x_",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox["/",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox["y_",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], 
          StyleBox[" ",
            FontWeight->"Bold"], 
          StyleBox["\[Rule]",
            FontWeight->"Bold"], 
          StyleBox[\(Simplify[x\ /y]\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  ", estas se ejecutar\[AAcute]n ",
  StyleBox["antes",
    FontSlant->"Italic"],
  " de aplicar la regla lo que, en este caso al ser ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(Simplify[x/y] = x/y\),
          FontWeight->"Bold"], TraditionalForm]]],
  " (pues ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          FontWeight->"Bold"], TraditionalForm]]],
  " e ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          FontWeight->"Bold"], TraditionalForm]]],
  " son solamente s\[IAcute]mbolos y nada hay que simplificar) obtendr\
\[IAcute]amos la regla ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["x_",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox["/",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox["y_",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], 
          StyleBox[" ",
            FontWeight->"Bold"], 
          StyleBox["\[Rule]",
            FontWeight->"Bold"], 
          StyleBox[\(x\ /y\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  " que no har\[IAcute]a absolutamente nada. Estos casos se solucionan usando \
una regla de sustituci\[OAcute]n diferida de la forma ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["x_",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox["/",
              FontWeight->"Bold"], 
            StyleBox["y_",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], 
          StyleBox[" ",
            FontWeight->"Bold"], 
          StyleBox["\[RuleDelayed]",
            FontWeight->"Bold"], 
          RowBox[{
            StyleBox["Simplify",
              FontWeight->"Bold"], 
            StyleBox["[",
              FontWeight->"Bold"], 
            StyleBox[\(x/y\),
              FontWeight->"Bold"], "]"}]}], TraditionalForm]]],
  "."
}], "Text"],

Cell[BoxData[{
    \(\(x\^2 - 1\)\/\(x + 1\) /. x_/y_ \[Rule] Simplify[x/y]\  (*\ 
      no\ hace\ nada\ *) \), "\[IndentingNewLine]", 
    \(\(x\^2 - 1\)\/\(x + 1\) /. \(\(x_/
          y_\)\(\[RuleDelayed]\)\(\ \)\(Simplify[x/y]\)\(\ \)\( (*\ 
          simplifica\ *) \)\)\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["C\[AAcute]lculo de extremos locales", "Section"],

Cell["Consideremos la siguiente funci\[OAcute]n polin\[OAcute]mica.", "Text"],

Cell[BoxData[
    \(Clear["\<Global`*\>"]\)], "Input"],

Cell[BoxData[
    \(f[x_] := 
      0.487857\ x + 0.417177\ x\^2 - 4.13604\ x\^3 + 3.01854\ x\^4 + 
        13.0446\ x\^5 - 13.0802  x\^6 - 0.983014\ x\^7 + 1.07625\ x\^8 - 
        9.44444  x\^9 + 10\ \ x\^10\)], "Input"],

Cell["Los puntos cr\[IAcute]ticos son los ceros de la derivada.", "Text"],

Cell[BoxData[
    \(puntoscriticos = NSolve[\(f'\)[x] == 0, x]\)], "Input"],

Cell[TextData[{
  "Hemos obtenido una lista cuyos elementos son listas formadas por un \
\[UAcute]nico elemento que es una regla de sustituci\[OAcute]n de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Rule] soluci\[OAcute]n\)]],
  ". Para obtener una lista con los puntos cr\[IAcute]ticos basta aplicar a ",
  
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " la lista de listas de reglas de sustituci\[OAcute]n obtenida."
}], "Text"],

Cell[BoxData[
    \(puntoscriticos = x /. puntoscriticos\)], "Input"],

Cell["\<\
Solamente nos interesan los puntos cr\[IAcute]ticos reales. Podemos \
seleccionarlos f\[AAcute]cilmente como sigue.\
\>", "Text"],

Cell[BoxData[{
    \(numeroreal[x_] := Im[x] \[Equal] 0\  (*\ 
      x\ es\ real\ si\ su\ parte\ imaginaria\ es\ cero\ *) \), 
    \(puntoscriticos = Select[puntoscriticos, numeroreal]\)}], "Input"],

Cell["Podemos obtener los m\[AAcute]ximos relativos como sigue.", "Text"],

Cell[BoxData[{
    \(maxrelativo[x_] := \(\(f'\)'\)[x] < 0\), 
    \(maximosrelativos = Select[puntoscriticos, maxrelativo]; \n
    Print["\<Hay m\[AAcute]ximos relativos en los puntos\n\>", 
      maximosrelativos]\)}], "Input"],

Cell["\<\
Procedemos de igual forma para obtener los m\[IAcute]nimos relativos.\
\>", "Text"],

Cell[BoxData[{
    \(minrelativo[x_] := \(\(f'\)'\)[x] > 0\), 
    \(minimosrelativos = Select[puntoscriticos, minrelativo]; \n
    Print["\<Hay m\[IAcute]nimos relativos en los puntos\n\>", 
      minimosrelativos]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Variables locales y variables globales", "Section"],

Cell[TextData[{
  "Cada vez que declaras una variable o una funci\[OAcute]n ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " la guarda en alg\[UAcute]n ",
  StyleBox["contexto.",
    FontSlant->"Italic"],
  " Por defecto el contexto en el que se guardan todas las variables y \
funciones definidas por el usuario es el contexto ",
  StyleBox["Global",
    FontFamily->"Courier"],
  ". Esto es as\[IAcute] para que dichas variables y funciones puedan ser \
usadas en cualquier celda en cualquier momento."
}], "Text"],

Cell[BoxData[
    \(var = 10; \n\(?var\)\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " te dice que ",
  StyleBox["var",
    FontFamily->"Courier"],
  " es una variable almacenada en el contexto ",
  StyleBox["Global",
    FontFamily->"Courier"],
  " cuyo valor actual es 10. Muchas veces es conveniente usar alguna variable \
o alguna funci\[OAcute]n para realizar una tarea muy espec\[IAcute]fica y no \
nos interesa que dicha variable o funci\[OAcute]n pueda ser accesible desde \
otras instancias del programa. Para ello ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone del comando ",
  StyleBox["Module[{",
    FontFamily->"Courier"],
  StyleBox["x", "TI",
    FontFamily->"Courier"],
  StyleBox[",", "MR",
    FontFamily->"Courier"],
  StyleBox["y", "TI",
    FontFamily->"Courier"],
  StyleBox[",...", "MR",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Courier"],
  Cell[BoxData[
      \(TraditionalForm\`}\)], "InlineFormula",
    FontFamily->"Courier"],
  StyleBox[",", "MR",
    FontFamily->"Courier"],
  StyleBox["expr]", "TI",
    FontFamily->"Courier",
    FontSlant->"Plain"],
  "que especifica que los s\[IAcute]mbolos ",
  StyleBox["x, y,...",
    FontFamily->"Courier"],
  " en ",
  StyleBox["expr",
    FontFamily->"Courier"],
  " deben ser tratados como variables locales."
}], "Text"],

Cell[BoxData[
    RowBox[{\(Module[{var}, var = 0; var]\), 
      RowBox[{"(*", " ", 
        RowBox[{
        "Mathematica", " ", "nos", " ", "devuelve", " ", "el", " ", "valor", 
          " ", "de", " ", "la", " ", 
          StyleBox["variable",
            FontSlant->"Italic"], 
          StyleBox[" ",
            FontSlant->"Italic"], 
          StyleBox["local",
            FontSlant->"Italic"], " ", "\"\<var\>\""}], " ", "*)"}]}]], 
  "Input"],

Cell[BoxData[
    \(\(var
    \  (*\ "\<var\>"\ sigue\ siendo\ una\ variable\ global\ y\ su\ valor\ no\ 
        ha\ cambiado\ *) \)\)], "Input"],

Cell["\<\
Aqu\[IAcute] tienes otro ejemplo para que entiendas la diferencia entre \
variable global y local.\
\>", "Text"],

Cell[BoxData[{
    \(t = 5; 
    \  (*\ declaramos\ "\<t\>"\ como\ variable\ global\ con\ valor\ inicial\ 5
        \ *) \nf[x_] := Module[{t}, t = \((1 + x)\)^2; Expand[t]] (*\ 
      declaramos "\<t\>" como\ una\ variable\ local\ *) \), 
    \(f[a + b]\)}], "Input"],

Cell[BoxData[
    \(\(?t\)\)], "Input"],

Cell[TextData[{
  "Observa que Module[{x,y,...}, expr ] tiene dos argumentos: las variables \
locales, {x,y,...}, y \"expr\" que es una expresi\[OAcute]n o una sucesi\
\[OAcute]n de expresiones separadas por punto y coma. Recuerda que para que ",
  
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " realice una sucesi\[OAcute]n de operaciones y muestre en pantalla la \
\[UAcute]ltima basta con que las escribas una a continuaci\[OAcute]n de otra \
separadas por punto y coma. "
}], "Text"],

Cell["\<\
La localizaci\[OAcute]n de variables combinada con el operador de sustituci\
\[OAcute]n es muy \[UAcute]til para definir derivadas de forma segura. \
\>", "Text"],

Cell[BoxData[{
    \(Clear[f, h]\), 
    \(f[x_] := x^2\ *\ Tan[x]\), 
    \(h[x_] := Module[{s}, D[f[s], {s, 5}] /. s -> x]\  (*\ 
      localizamos\ la\ variable\ respecto\ a\ la\ cual\ derivamos\ y\ 
        despu\[EAcute]s\ la\ sustituimos\ por\ la\ variable\ x\ *) \), 
    \(h[3]\), 
    \(Clear[f, h]\)}], "Input"],

Cell["\<\
De igual forma se procede para definir derivadas parciales. Podemos definir f\
\[AAcute]cilmente un comando que calcule el vector gradiente de una funci\
\[OAcute]n de tres variables.\
\>", "Text"],

Cell[BoxData[
    \(\(grad[f_]\)[x_, y_, z_] := {D[f[x, y, z], x], D[f[x, y, z], y], 
        D[f[x, y, z], z]}\)], "Input"],

Cell[TextData[{
  "Observa que la funci\[OAcute]n tambi\[EAcute]n debe ser una variable en \
nuestro comando porque queremos que nuestro comando valga para cualquier \
funci\[OAcute]n y no solamente para una funci\[OAcute]n concreta. La expresi\
\[OAcute]n \"grad[f_][x_,y_,z_]\" es otra forma de escribir \
\"grad[f_,x_,y_,z_]\". En ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " puedes agrupar las variables en corchetes como t\[UAcute] quieras. Veamos \
si nuestro comando funciona."
}], "Text"],

Cell[BoxData[{
    \(h[x_, y_, z_] := z\^2*Sin[x*y]\), 
    \(\(grad[h]\)[x, y, z]\)}], "Input"],

Cell["Todo parece correcto pero no lo es.", "Text"],

Cell[BoxData[{
    \(\(grad[h]\)[0, 1, 1]\), 
    \(Clear[h]\)}], "Input"],

Cell[TextData[{
  "Nos ha vuelto a pasar lo mismo que antes. Aunque en este caso es posible \
usar la asignaci\[OAcute]n directa (porque ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " sabe que \" f \" es una variable y realiza simb\[OAcute]licamente las \
operaciones indicadas sobre \" f \") lo m\[AAcute]s prudente es localizar las \
variables respecto a las que derivamos y, una vez hecha la \
derivaci\[OAcute]n, sustituimos las variables locales por las nuestras."
}], "Text"],

Cell[BoxData[{
    \(Clear[grad]\), 
    \(\(grad[f_]\)[x_, y_, z_] := 
      Module[{u, v, 
          w}, {D[f[u, v, w], u], D[f[u, v, w], v], D[f[u, v, w], w]} /. {
            u -> x, v -> y, w -> z}]\)}], "Input"],

Cell[BoxData[{
    \(h[x_, y_, z_] := z\^2*Sin[x*y]\), 
    \(\(grad[h]\)[x, y, z]\), 
    \(\(grad[h]\)[0, 1, 1]\)}], "Input"],

Cell["\<\
Veamos otro ejemplo del uso de variables locales. Supongamos que queremos \
obtener valores de una funci\[OAcute]n que depende de un par\[AAcute]metro \
que toma valores de forma aleatoria. \
\>", "Text"],

Cell[BoxData[{
    \(\(Clear[f];\)\), "\[IndentingNewLine]", 
    \(a := Random[Integer, {1, 5}] (*\ 
      a\ toma\ valores\ enteros\ comprendidos\ entre\ 1\ y\ 5\ de\ forma\ \
aleatoria . \ 
          Observa\ que\ no\ podemos\ usar\ la\ asignaci\[OAcute]n\ directa\ *) \
\), "\[IndentingNewLine]", 
    \(f[x_] := a*x^2 + 7  x - a\ ;  (*\ 
      la\ funci\[OAcute]n\ cuyo\ par\[AAcute]metro\ es\ a . \ 
          Observa\ que\ no\ podemos\ usar\ la\ asignaci\[OAcute]n\ directa\ \
*) \[IndentingNewLine]Table[f[x], {x, 1, 5}] // Sort\  (*\ 
      evaluamos\ f\ en\ los\ n\[UAcute]meros\ enteros\ 1, 2, 3, 4, 
      5\ *) \), "\[IndentingNewLine]", 
    \(\(\(Table[a*x^2 + 7  x - a, {a, 1, 5}, {x, 1, 5}] // 
        Flatten\)\(//\)\(Union\)\( (*\ 
        todos\ los\ posibles\ valores\ de\ f\ cuando\ el\ par\[AAcute]metro\ \
a\ y\ la\ variable\ x\ toman\ los\ valores\ enteros\ 1, 2, 3, 4, 
        5\ *) \)\)\)}], "Input"],

Cell[TextData[{
  "Salvo rara casualidad, podr\[AAcute]s ver que en la primera lista hay \
valores que no est\[AAcute]n en la segunda. Extra\[NTilde]o, \
\[DownQuestion]verdad? Para saber lo que est\[AAcute] pasando podemos pedir a \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que ejecute paso a paso el comando conflictivo."
}], "Text"],

Cell[BoxData[
    \(Trace[f[2]]\)], "Input"],

Cell[TextData[{
  "Procura entender lo anterior. Ahora est\[AAcute] claro lo que pasa: para \
evaluar la funci\[OAcute]n ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ha llamado dos veces a la variable \"a\" asignando valores distintos en \
cada caso lo que provoca el error. Esto puede arreglarse localizando el par\
\[AAcute]metro."
}], "Text"],

Cell[BoxData[{
    \(\(Clear[f];\)\), "\[IndentingNewLine]", 
    \(\(valores := 
        Module[{b}, a := Random[Integer, {1, 5}]; b = a; 
          f[x_] := b*x^2 + 7  x - b; 
          Table[f[x], {x, 1, 5}] // Sort\ ];\)\), "\[IndentingNewLine]", 
    \(valores\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Programaci\[OAcute]n basada en listas", "Section"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " proporciona la posibilidad de programar usando listas. Con frecuencia es \
posible sustituir procesos iterativos y bucles por el uso apropiado de \
listas. Supongamos, por ejemplo, que queremos programar el c\[AAcute]lculo de \
los puntos medios de una lista de n\[UAcute]meros; es decir, se trata de \
calcular los puntos medios de cada dos n\[UAcute]meros consecutivos de la \
lista dada. Hagamos esto de dos formas diferentes. En la primera usamos \
programaci\[OAcute]n procedimental y en la segunda programaci\[OAcute]n \
basada en listas. "
}], "Text"],

Cell[BoxData[
    \(puntosmedios[lista_] := 
      Module[{x},  (*\ localizamos\ la\ variable\ "\<x\>"\ *) \ \n\t\t\t
        x = Table[0, {Length[lista] - 1}]\  (*\ valor\ inicial\ de\ x\ *) ; \n
        \t\tFor[k = 1, k \[LessEqual] \ Length[lista] - 1, 
          x[\([k]\)] = \((lista[\([k]\)] + lista[\([k + 1]\)])\)*0.5; 
          \(k++\)] (*\ calculamos\ los\ puntos\ medios\ *) \ ; \n\t\tx
        \  (*\ pedimos\ a\ Mathematica\ que\ devuelva\ el\ valor\ actual\ de\ 
            x\ *) ]\)], "Input"],

Cell[BoxData[
    \(puntosmedios[Range[0, 100]]\)], "Input"],

Cell[BoxData[
    \(nuevospuntosmedios[lista_] := 
      \((Drop[lista, 1] + Drop[lista, \(-1\)])\)*0.5\)], "Input"],

Cell[BoxData[
    \(nuevospuntosmedios[Range[0, 100]]\)], "Input"],

Cell[TextData[{
  "Pidamos a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que nos diga el tiempo que tarda en calcular con los comandos que \
acabamos de definir los puntos medios de una lista con los primeros cien mil \
n\[UAcute]meros."
}], "Text"],

Cell[BoxData[
    \(\(Timing[puntosmedios[Range[0, 100000]]]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(\(Timing[nuevospuntosmedios[Range[0, 100000]]]\)[\([1]\)]\)], "Input"],

Cell["\<\
Como puedes comprobar la segunda forma es mucho m\[AAcute]s eficaz que la \
primera.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compresi\[OAcute]n de una lista de datos", "Section"],

Cell[TextData[{
  "Vamos a ver con un ejemplo que, en ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " el uso de comandos espec\[IAcute]ficos para trabajar con listas suele dar \
mejores resultados que la \"programaci\[OAcute]n al estilo C\". \nSe trata de \
comprimir una lista de datos por el procedimiento de sustituir cada cadena de \
m repeticiones de un mismo dato \"x\" por {x,m}. Consideremos, por ejemplo, \
la lista siguiente."
}], "Text"],

Cell[BoxData[
    \(lista = {2, 1, 1, 1, 3, 3, 5, 5, 5, 5, 1, 1, 3, 3, 3, 3, 7}\)], "Input"],

Cell["\<\
La salida del comando que queremos definir debe ser \
{{2,1},{1,3},{3,2},{5,4},{1,2},{3,4},{7,1}}. Podemos usar el comando \
Split[lista] que divide una lista en sublistas formadas por las cadenas de un \
mismo elemento repetido en la lista inicial.\
\>", "Text"],

Cell[BoxData[
    \(temp = Split[lista]\)], "Input"],

Cell["\<\
Todo lo que tenemos que hacer ahora es contar el n\[UAcute]mero de elementos \
de cada una de las sublistas y presentar el resultado de la forma deseada. \
Para ello definimos una funci\[OAcute]n apropiada y la aplicamos a la lista \
anterior.\
\>", "Text"],

Cell[BoxData[{
    \(\(codi[x_] := {x[\([1]\)], Length[x]};\)\), "\[IndentingNewLine]", 
    \(Map[codi, temp]\)}], "Input"],

Cell["Podemos resumir todo el proceso como sigue.", "Text"],

Cell[BoxData[{
    \(Clear["\<@\>"]\), "\[IndentingNewLine]", 
    \(comprime[x_] := 
      Module[{temp, codi}, temp = Split[x]; 
        codi[z_List] := {z[\([1]\)], Length[z]}; \[IndentingNewLine]Map[codi, 
          temp]]\)}], "Input"],

Cell["\<\
Para comprobar la eficacia del comando definido vamos a hacer que codifique \
una lista muy larga. El siguiente comando \"listaaleatoria[n_,prob_]\" genera \
una lista de n elementos cada uno de ellos elegido al azar del 1 al 100 y la \
probabilidad de que un elemento elegido se repita en la siguiente elecci\
\[OAcute]n es igual a \"prob\".\
\>", "Text"],

Cell[BoxData[
    \(listaaleatoria[n_, prob_] := 
      Module[{c}, c = Random[Integer, {1, 100}]; 
        Table[If[Random[] > prob, c = Random[Integer, {1, 100}], 
            c], {n}]]\)], "Input",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(listaaleatoria[300,  .7]\)], "Input"],

Cell[BoxData[{
    \(\(d = listaaleatoria[100000,  .7];\)\), "\[IndentingNewLine]", 
    \(Timing[\(comprime[d];\)]\)}], "Input",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[{
  "Hemos usado comandos espec\[IAcute]ficos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para trabajar con listas (Split[ ]). Podemos hacer esto mismo con \
programaci\[OAcute]n procedimental."
}], "Text"],

Cell[BoxData[
    \(nuevocomprime[x_] := 
      Module[{lista, resultado, count, actual}, lista = x; resultado = {}; 
        While[lista \[NotEqual] {}, actual = First[lista]; count = 0; 
          While[lista \[NotEqual] {} && 
              actual \[Equal] First[lista], \(++count\); 
            lista = Rest[lista];]; AppendTo[resultado, {actual, count}];]; 
        resultado]\)], "Input",
  AspectRatioFixed->False,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["Probemos este comando.", "Text"],

Cell[BoxData[{
    \(tp = listaaleatoria[50,  .7]\), "\[IndentingNewLine]", 
    \(nuevocomprime[tp]\)}], "Input"],

Cell["Comparamos los dos comandos definidos.", "Text"],

Cell[BoxData[{
    \(\(d = listaaleatoria[10000,  .7];\)\), "\n", 
    \(Timing[\(comprime[d];\)]\), "\[IndentingNewLine]", 
    \(Timing[\(nuevocomprime[d];\)]\)}], "Input"],

Cell["\<\
La cosa est\[AAcute] clara. Naturalmente, hay ocasiones en las que una \
combinaci\[OAcute]n de estos procedimientos es lo adecuado. \
\>", "Text"],

Cell[BoxData[
    \(\(\(criba[
        n_Integer]\)\(:=\)\(Module[{lista = Range[n], 
          p}, \[IndentingNewLine]For[p = 2, 
          p \[NotEqual] 1 && 
            p \[LessEqual] 
              Floor[Sqrt[
                  n]], \[IndentingNewLine]\(p++\), \[IndentingNewLine]Do[
            lista[\([i]\)] = 1, {i, 2  p, n, 
              p}]]; \[IndentingNewLine]DeleteCases[lista, 1]]\)\( (*\ 
        calcula\ todos\ los\ n\[UAcute]meros\ primos\ menores\ o\ iguales\ \
que\ n\ *) \)\)\)], "Input"],

Cell["Este comando es bastante r\[AAcute]pido.", "Text"],

Cell[BoxData[
    \(Timing[\(criba[100000];\)]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Programaci\[OAcute]n funcional", "Section"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " proporciona un entorno de ",
  StyleBox["programaci\[OAcute]n funcional",
    FontSlant->"Italic"],
  " cuyos comandos principales son los siguientes:\n",
  Cell[BoxData[
      FormBox[
        RowBox[{"Nest", "[", 
          RowBox[{"f", ",", 
            StyleBox["expr",
              FontSlant->"Italic"], ",", "n"}], "]"}], TraditionalForm]]],
  " aplica ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " veces la funci\[OAcute]n ",
  StyleBox["f", "TI"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "a ",
  StyleBox["expr", "TI"],
  ". \n",
  Cell[BoxData[
      FormBox[
        RowBox[{"NestList", "[", 
          RowBox[{"f", ",", 
            StyleBox["expr",
              FontSlant->"Italic"], ",", "n"}], "]"}], TraditionalForm]]],
  " proporciona una lista de ",
  Cell[BoxData[
      \(TraditionalForm\`n + 1\)]],
  " elementos cuyos elementos son las iteradas sucesivas de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " sobre ",
  Cell[BoxData[
      FormBox[
        StyleBox["expr",
          FontSlant->"Italic"], TraditionalForm]]],
  ", empezando en el valor inicial ",
  Cell[BoxData[
      FormBox[
        StyleBox["expr",
          FontSlant->"Italic"], TraditionalForm]]],
  " y terminando en ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f\^\([n]\)\), "(", 
          StyleBox["expr",
            FontSlant->"Italic"], ")"}], TraditionalForm]]],
  " (el resultado de aplicar ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " veces a ",
  Cell[BoxData[
      FormBox[
        StyleBox["expr",
          FontSlant->"Italic"], TraditionalForm]]],
  "). \nWhileNestList[",
  StyleBox["f, expr, test",
    FontSlant->"Italic"],
  "] proporciona la lista de las iteradas sucesivas de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " hasta que \"",
  StyleBox["test",
    FontSlant->"Italic"],
  "\" da False. Se entiende que \"test\" es una funci\[OAcute]n booleana que \
act\[UAcute]a sobre las salidas de las iteradas de ",
  StyleBox["f .\n",
    FontSlant->"Italic"],
  "En los comandos anteriores \"",
  StyleBox["expr",
    FontSlant->"Italic"],
  "\" puede ser una lista. En cuyo caso el comando calcula las sucesivas \
listas aplicando a cada elemento de \"",
  StyleBox["expr",
    FontSlant->"Italic"],
  "\" la funci\[OAcute]n ",
  StyleBox["f. ",
    FontSlant->"Italic"],
  "La salida es ahora una lista de listas.",
  "\nFoldList",
  StyleBox["[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{a,b,c,d,...}", "TI"],
  StyleBox["]", "MR"],
  "proporciona la lista ",
  Cell[BoxData[
      \(TraditionalForm\`\(\({x, f[x, a], 
        f[f[x, a], b],  ... }\)\(\ \)\)\)]],
  ".\nFold",
  StyleBox["[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{a,b,c,d,...}", "TI"],
  StyleBox["]", "MR"],
  "proporciona el \[UAcute]ltimo elemento de FoldList",
  StyleBox["[", "MR"],
  StyleBox["f", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["x", "TI"],
  StyleBox[",", "MR"],
  " ",
  StyleBox["{a,b,c,d,...}", "TI"],
  StyleBox["]", "MR"],
  ".\nLos siguientes ejemplos muestran la potencia de estos comandos."
}], "Text"],

Cell["\<\
maxima[x_]:= Union[FoldList[Max, First[x], x]] (* esta funci\[OAcute]n \
selecciona en una lista num\[EAcute]rica los elementos que son mayores que \
todos los que les preceden *)
lista = {47,43,43,43,43,43,43,43,43,171,171,171,171,171,171,171,171,88,88,88,\
23,23,23,23,23,23,23,23,90,90,237,237,237,237,53,53,116,140,140,140,140,85,85,\
85,85,85,85,85,85,85,85,85,85,85,241,241,61,61,171,171,171,171,171,196,196,\
196,196,196,196,196,196,196,5,5,5,250,250,250,245,245,245,66,56,56,56,56,56,\
56,56,190,190,190,190,190,34,34,34,34,34,34};
cumbres = maxima[lista]\
\>", "Input",
  CellTags->{"b:16", "IPM3.4.6.1"}],

Cell[TextData[{
  "Si quieres saber los lugares que ocupan los n\[UAcute]meros anteriores",
  StyleBox[" la primera vez",
    FontSlant->"Italic"],
  " que aparecen en la lista, puedes hacerlo como sigue."
}], "Text"],

Cell[BoxData[
    \(Table[{cumbres[\([k]\)], \(Position[lista, cumbres[\([k]\)]]\)[\([1, 
            1]\)]}, {k, 1, 5}]\)], "Input"],

Cell[BoxData[
    \(Clear["\<@\>"]\)], "Input"],

Cell[BoxData[{
    RowBox[{\(g[z_] := \(\(I\)\(^\)\(z\)\(\ \ \ \)\)\), \( (*\ 
        definimos\ una\ funci\[OAcute]n\ que\ vamos\ a\ iterar\ *) \), 
      " "}], "\[IndentingNewLine]", 
    RowBox[{\(lista = NestList[g, 0.  + I, 39]\), " ", 
      RowBox[{"(*", " ", 
        RowBox[{
        "los", " ", "primeros", " ", "40", " ", "t\[EAcute]rminos", " ", "de",
           " ", "la", " ", "sucesi\[OAcute]n", " ", 
          FormBox[
            RowBox[{\(x[n + 1]\), "=", 
              RowBox[{\(\[ImaginaryI]\^x[n]\), "con", " ", 
                FormBox[\(x[1] = \[ImaginaryI]\),
                  "TraditionalForm"]}]}],
            "TraditionalForm"]}], " ", 
        "*)"}]}], "\[IndentingNewLine]", \(\(Show[
      Graphics[{PointSize[ .015], 
          Map[Point, Transpose[{Re[lista], Im[lista]}]]}], Axes \[Rule] True, 
      PlotRange \[Rule] All, AspectRatio \[Rule] 1]\)\(;\)\(\ \)\( (*\ 
      representamos\ gr\[AAcute]ficamente\ los\ puntos\ *) \)\)}], "Input"],

Cell["\<\
Veamos una funci\[OAcute]n que extrae 5 cartas al azar de una baraja de 40 \
cartas.\
\>", "Text"],

Cell[BoxData[{
    \(cartas = 
      Flatten[Outer[List, 
          Range[10], {\[ClubSuit], \[SpadeSuit], \[FilledDiamond], \
\[HeartSuit]}], 1] (*\ nuestra\ baraja\ *) \), "\[IndentingNewLine]", 
    \(extrae := 
      Module[{elige}, 
        elige[lista_] := 
          Drop[lista, {Random[
                Integer, {1, Length[lista]}]}]; \[IndentingNewLine]Complement[
          cartas, Nest[elige, cartas, 5]]]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Primitivas gr\[AAcute]ficas", "Section"],

Cell[TextData[{
  "El comando b\[AAcute]sico para representar gr\[AAcute]ficas en el plano es \
",
  StyleBox["Plot[funcion,{x,xmin,xmax},opciones]",
    FontWeight->"Bold"],
  ".",
  StyleBox[" ",
    FontWeight->"Bold"],
  "Ya debes conocer dicho comando y sus opciones principales. Hagamos una \
representaci\[OAcute]n gr\[AAcute]fica muy sencilla."
}], "Text"],

Cell[BoxData[
    \(\(\(Plot[x^2, {x, \(-1\), 1}]\ \) (*\ 
      usamos\ el\ comando\ sin\ ninguna\ opci\[OAcute]n\ *) \)\)], "Input"],

Cell[TextData[{
  "Como puedes ver, el comando Plot[ ] representa la gr\[AAcute]fica y \
proporciona la salida \"Out[n]=- Graphics - \". ",
  StyleBox["Seguro que te has preguntado muchas veces qu\[EAcute] quiere \
decir ese \[OpenCurlyDoubleQuote]-Graphics-\[CloseCurlyDoubleQuote]. Pues \
bien, ah\[IAcute] guarda ",
    FontFamily->"Times New Roman"],
  StyleBox["Mathematica",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[" toda la informaci\[OAcute]n sobre el gr\[AAcute]fico en cuesti\
\[OAcute]n. Podemos verla con el comando InputForm[ ].",
    FontFamily->"Times New Roman"]
}], "Text"],

Cell[BoxData[
    \(\(InputForm[%]\  (*\ 
      recuerda\ que\ "\<%\>"\ se\ refiere\ a\ la\ \[UAcute]ltima\ salida\ *) 
      \)\)], "Input"],

Cell["\<\
Este resultado muestra que un gr\[AAcute]fico es un comando de la forma \
\>", "Text"],

Cell["Graphics[primitivas gr\[AAcute]ficas,opciones]. ", "Text",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell["\<\
En este caso todas las opciones son las prefijadas pues no hemos especificado \
ninguna y hay una \[UAcute]nica primitiva gr\[AAcute]fica, Line[ ], cuya \
sintaxis es\
\>", "Text",
  FontFamily->"Times New Roman"],

Cell["Line[{{x1,y1},{x2,y2}...}]", "Text",
  TextAlignment->Center,
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "que dibuja una l\[IAcute]nea poligonal que une los puntos \
{x1,y1},{x2,y2}...; es decir, el gr\[AAcute]fico generado por Plot[ ] es una \
poligonal formada por segmentos que unen puntos pr\[OAcute]ximos de la gr\
\[AAcute]fica de la funci\[OAcute]n. Estos puntos son tan pr\[OAcute]ximos \
que, a simple vista, no se advierte que la curva est\[AAcute] formada por la \
yuxtaposici\[OAcute]n de los segmentos que unen cada punto con el siguiente. \
\nAdem\[AAcute]s de Line[ ] otras primitivas gr\[AAcute]ficas son Point[ ], \
Rectangle[ ], Circle[ ], Disk[ ], Polygon[ ] y Text[ ]. ",
  StyleBox[
  "La primitiva Polygon[{x1,y1},{x2,y2},..] representa un pol\[IAcute]gono \
relleno cuyos v\[EAcute]rtices son los puntos {x1,y1},{x2,y2}, . . . y cuyos \
lados son los segmentos que unen cada punto con el siguiente y el \
\[UAcute]ltimo con el primero. Por ejemplo, Polygon[{0,0},{1,0},{0,1}] es un \
tri\[AAcute]ngulo. Un caso especial de Polygon[ ] es Rectangle[ ] en la que \
se dan los v\[EAcute]rtices inferior izquierdo y superior derecho. La \
primitiva Disk[ ] dibuja c\[IAcute]rculos rellenos. La primitiva \
Circle[{x,y},{rx,ry}], produce una elipse de semiejes rx y ry. Para obtener \
arcos de circunferencia o sectores de c\[IAcute]rculos o de elipses basta \
incluir al final del correspondiente comando una lista de la forma {t1,t2} \
donde 0\[LessEqual]t1<t2\[LessEqual]2Pi. Por ejemplo, \
Disk[{1,1},{2,3},{Pi/2,3Pi/2}] es un sector de elipse comprendido en el \
semiplano de la izquierda.",
    FontFamily->"Times New Roman"],
  " Si tienes alguna duda sobre la sintaxis de estas primitivas \
gr\[AAcute]ficas debes consultar la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". \nComo su nombre indica, ",
  StyleBox[
  "las primitivas gr\[AAcute]ficas son los elementos b\[AAcute]sicos \
(primitivos) que utiliza Mathematica para crear gr\[AAcute]ficos complejos",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". El siguiente ejemplo muestra a la primitiva Point[ ] en acci\[OAcute]n. \
Usamos para ello el comando ListPlot[ ] que sirve para representar \
gr\[AAcute]ficamente listas de puntos en el plano."
}], "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    StyleBox[
      \(ListPlot[Table[i^2, {i, 3}], \n
        PlotStyle -> {PointSize[ .02], RGBColor[1, 0, 0]}]\),
      FormatType->StandardForm], 
    StyleBox[\(InputForm[%]\),
      FormatType->StandardForm]}], "Input"],

Cell[TextData[{
  StyleBox[
  "Observa que los puntos de un gr\[AAcute]fico realizado con ListPlot[ ] son \
producidos por la primitiva gr\[AAcute]fica Point[ ]. F\[IAcute]jate tambi\
\[EAcute]n en que las especificaciones de color y tama\[NTilde]o de los \
puntos, que indicamos con PlotStyle figuran en una lista que contiene como ",
    FontFamily->"Times New Roman"],
  StyleBox["sublista",
    FontFamily->"Times New Roman",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["a la lista de los puntos del gr\[AAcute]fico ",
    FontFamily->"Times New Roman"],
  StyleBox["a la cual preceden",
    FontFamily->"Times New Roman",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[
  ". Las especificaciones como PointSize[ ] o RGBColor[ ] que preceden a una \
primitiva gr\[AAcute]fica o a una lista de primitivas gr\[AAcute]ficas a las \
que modifican, se conocen como ",
    FontFamily->"Times New Roman"],
  StyleBox["directivas gr\[AAcute]ficas",
    FontFamily->"Times New Roman",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["o, simplemente, ",
    FontFamily->"Times New Roman"],
  StyleBox["directivas",
    FontFamily->"Times New Roman",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[
  ". Otras directivas que ya conoces son Thickness[ ] y Dashing[ ]. En \
general, las especificaciones dadas con PlotStyle en comandos como Plot[ ],  \
ListPlot[ ], o ParametricPlot[ ] que tienen como salida un objeto \
gr\[AAcute]fico, son ",
    FontFamily->"Times New Roman"],
  StyleBox["directivas gr\[AAcute]ficas que se aplican globalmente",
    FontFamily->"Times New Roman",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[
  ". Lo que hacen precisamente estos comandos es facilitar la construcci\
\[OAcute]n de objetos gr\[AAcute]ficos, es decir de comandos del tipo",
    FontFamily->"Times New Roman"],
  StyleBox[" ",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[
  "Graphics[primitivas gr\[AAcute]ficas,opciones] y mostrarlos mediante un \
comando",
    FontFamily->"Times New Roman"],
  StyleBox[" ",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["Show[ ]",
    FontFamily->"Times New Roman"],
  StyleBox[". \n",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox[
  "Puedes construir directamente objetos gr\[AAcute]ficos en Mathematica \
dando una lista (de listas) de primitivas gr\[AAcute]ficas. Es posible \
incluir en cada lista directivas que especifican la forma en que se \
representar\[AAcute]n los siguientes elementos gr\[AAcute]ficos de esa lista \
o de sus sublistas, pero dichas directivas no tiene ning\[UAcute]n efecto \
fuera de la lista que las contiene. Procura entender los ejemplos que \
siguen.",
    FontFamily->"Times New Roman"]
}], "Text"],

Cell[BoxData[
    RowBox[{
      StyleBox[\(vertices = {Hue[0] (*\ especificamos\ color\ *) , 
            PointSize[ .03]\  (*\ 
              especificamos\ tama\[NTilde]o\ de\ cada\ punto\ *) , \n
            Table[Point[{Cos[2\ k\ Pi/5], Sin[2\ k\ Pi/5]}], {k, 0, 5}]}\),
        FormatType->StandardForm], 
      StyleBox[";",
        FormatType->StandardForm], 
      StyleBox[" ",
        FormatType->StandardForm], 
      StyleBox[\( (*\ 
          usamos\ la\ primitiva\ gr\[AAcute]fica\ Point[]\ para\ generar\ una\
\ lista\ con\ los\ v\[EAcute]rtices\ *) \),
        FormatType->StandardForm], "\n", 
      StyleBox[\(lados = {Hue[ .5] (*\ especificamos\ color\ *) , 
            Thickness[ .02] (*\ 
              especificamos\ grosor\ de\ l\[IAcute]nea\ *) , 
            Line[Table[\n{Cos[2\ k\ Pi/5], Sin[2\ k\ Pi/5]}, {k, 0, 5}]]}\),
        FormatType->StandardForm], 
      StyleBox[";",
        FormatType->StandardForm], 
      StyleBox[" ",
        FormatType->StandardForm], 
      StyleBox[\( (*\ 
          usamos\ la\ primitiva\ gr\[AAcute]fica\ Line[]\ para\ generar\ una\ \
l\[IAcute]nea\ poligonal\ que\ une\ los\ v\[EAcute]rtices\ *) \),
        FormatType->StandardForm], "\n", 
      StyleBox[\(pentagono = 
          Show[Graphics[{lados, vertices}], AspectRatio -> Automatic]\),
        FormatType->StandardForm], 
      StyleBox[";",
        FormatType->StandardForm], 
      StyleBox[\( (*\ 
          el\ punto\ y\ coma\ al\ final\ es\ para\ que\ no\ aparezca\ la\ \
salida\  - \ Graphics\  - \ *) \),
        FormatType->StandardForm]}]], "Input"],

Cell[BoxData[
    StyleBox[
      \(Show[Graphics[{{Hue[0], Rectangle[{0, 0}, {1, 1}]}, 
            \n{Hue[ .5], Thickness[ .02], Circle[{1, 1}, 1/3]}}], \n
        AspectRatio -> Automatic]; \),
      FormatType->StandardForm]], "Input"],

Cell[TextData[
"Observa que en estas representaciones no figuran los ejes de coordenadas. \
Ello se debe a las opciones por defecto del comando Graphics[ ] entre las que \
figura Axes\[Rule]False. "], "Text"],

Cell[BoxData[
    \(Options[Graphics]\)], "Input"],

Cell[BoxData[
    \(\(Show[Graphics[Circle[{0, 0}, {2, 1}]], AspectRatio -> Automatic, 
      Axes \[Rule] True]; \)\)], "Input"],

Cell["\<\
Para hacer la representaci\[OAcute]n gr\[AAcute]fica de una funci\[OAcute]n, \
el comando Plot[ ] llama muchas veces a dicha funci\[OAcute]n. Podemos verlo \
con el siguiente ejemplo.\
\>", "Text"],

Cell[BoxData[{
    \(\(Clear[f, n];\)\), "\[IndentingNewLine]", 
    \(n = 0; 
    f[x_] := \((\(n++\); Sin[x\^3])\)\  (*\ 
      cada\ vez\ que\ se\ ejecute\ esta\ funci\[OAcute]n\ aumentar\[AAcute]\ \
una\ unidad\ el\ valor\ de\ n . \ 
          Es\ obligado\ usar\ asignaci\[OAcute]n\ diferida\ *) \), "\
\[IndentingNewLine]", 
    \(\(Plot[f[x], {x, 0, Pi}];\)\), "\[IndentingNewLine]", 
    \(n\  (*\ 
      n\[UAcute]mero\ de\ veces\ que\ el\ comando\ Plot[\ ]\ ha\ llamado\ a\ \
la\ funci\[OAcute]n\ *) \)}], "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
Por eso, cuando la funci\[OAcute]n es complicada, el comando Plot[ ] puede \
consumir mucho tiempo. Algunas veces puede ser conveniente pedirle a Plot[ ] \
que eval\[UAcute]e la funci\[OAcute]n, lo que se hace con \
Plot[Evaluate[f[x]],{x,a,b}].\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Las opciones Prolog y Epilog", "Section"],

Cell[TextData[
"Las opciones Prolog\[Rule]{primitivas gr\[AAcute]ficas} y \
Epilog\[Rule]{primitivas gr\[AAcute]ficas} sirven para a\[NTilde]adir a una \
representaci\[OAcute]n gr\[AAcute]fica dada por un comando como Plot[ ] o \
ParametricPlot[ ] elementos gr\[AAcute]ficos especificados por las \
correspondientes primitivas gr\[AAcute]ficas. La diferencia entre ellos es \
que Prolog a\[NTilde]ade los elementos gr\[AAcute]ficos antes de que se \
represente la parte principal de la gr\[AAcute]fica y Epilog los \
a\[NTilde]ade despu\[EAcute]s. Los siguientes ejemplos ponen de manifiesto \
este comportamiento."], "Text"],

Cell[BoxData[
    \(\(\(Plot[Sin[x], {x, \(-Pi\), Pi}, 
      PlotStyle \[Rule] {Hue[ .64], Thickness[ .02]}, 
      Epilog \[Rule] {PointSize[0.05], 
          Hue[0], {Point[{\[Pi]/7, Sin[\[Pi]/7]}], 
            Point[{\[Pi]/5, Sin[\[Pi]/5]}], 
            Point[{\[Pi]/3, Sin[\[Pi]/3]}]}}]; 
    \) (*\ sobre\ la\ gr\[AAcute]fica\ de\ la\ funci\[OAcute]n\ Sin[x]\ hemos
        \ representado\ tres\ puntos\ en\ rojo . \ La\ gr\[AAcute]fica\ se\ 
        representa\ primero\ y\ los\ puntos\ despu\[EAcute]s\ *) \)\)], 
  "Input"],

Cell[BoxData[
    \(\(\(Plot[Sin[x], {x, \(-Pi\), Pi}, 
      PlotStyle \[Rule] {Hue[ .64], Thickness[ .02]}, 
      Prolog \[Rule] {PointSize[0.05], 
          Hue[0], {Point[{\[Pi]/7, Sin[\[Pi]/7]}], 
            Point[{\[Pi]/5, Sin[\[Pi]/5]}], 
            Point[{\[Pi]/3, Sin[\[Pi]/3]}]}}]; 
    \) (*\ sobre\ la\ gr\[AAcute]fica\ de\ la\ funci\[OAcute]n\ Sin[x]\ hemos
        \ representado\ tres\ puntos\ en\ rojo . \ Ahora\ los\ puntos\ se\ 
        representan\ primero\ y\ la\ gr\[AAcute]fica\ despu\[EAcute]s\ *) 
      \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Funciones condicionadas", "Section"],

Cell[TextData[{
  "En esta secci\[OAcute]n vamos a ver c\[OAcute]mo se pueden definir \
funciones a trozos y c\[OAcute]mo podemos imponer que una funci\[OAcute]n \
determinada trabaje solamente con cierto tipo de datos. El operador ",
  StyleBox["Condition",
    FontWeight->"Bold"],
  "  ( ",
  StyleBox["/;",
    FontWeight->"Bold"],
  " ) tiene distintos usos; el que nos interesa ahora es de la forma \"",
  StyleBox["expr1:=expr2 /; test",
    FontWeight->"Bold"],
  "\" que representa una definici\[OAcute]n que debe aplicarse solamente si \
\"",
  StyleBox["test",
    FontWeight->"Bold"],
  "\" da \"True\". Aqu\[IAcute] es indispensable usar la asignaci\[OAcute]n \
diferida porque en otro caso ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " trata de comprobar inmediatamente \"",
  StyleBox["test",
    FontWeight->"Bold"],
  "\" con valores simb\[OAcute]licos lo que produce un error. Aqu\[IAcute] \
tienes un ejemplo."
}], "Text"],

Cell[BoxData[{
    \(Clear[f]\), 
    \(f[x_] := 2 - x\  /; x < 0\), 
    \(f[x_] := x^2 /; 0 \[LessEqual] x < 1\), 
    \(f[x_] := 2 + x /; 1 \[LessEqual] x\), 
    \(f[\(-2\)]\), 
    \(f[0]\), 
    \(f[1]\)}], "Input"],

Cell["Otro ejemplo.", "Text"],

Cell[BoxData[{
    \(Clear[f]\), 
    \(f[x_, y_] := Log[x + y] /; 0 < x + y\  && \ x^2 + y^2 < 16\), 
    \(f[\(-3\), 2]\  (*\ 
      la\ definici\[OAcute]n\ no\ se\ aplica\ por\ no\ cumplirse\ las\ 
        condiciones\ *) \), 
    \(f[2, 1]\), 
    \(f[3, 2]\), 
    \(f[3, 3]\  (*\ 
      la\ definici\[OAcute]n\ no\ se\ aplica\ por\ no\ cumplirse\ las\ 
        condiciones\ *) \)}], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " trabaja con varios tipos de n\[UAcute]meros como, por ejemplo, enteros \
(Integer), reales (Real) y complejos (Complex). Debes saber que, salvo que se \
indique otra cosa, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " trata por defecto todas las variables como n\[UAcute]meros complejos y \
esa es la raz\[OAcute]n de que a veces sus respuestas puedan parecerte err\
\[OAcute]neas o extra\[NTilde]as. Por ejemplo, para los n\[UAcute]meros \
complejos no siempre es cierto que ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\@a\), \(\@b\), " ", "sea", " ", "igual", " ", 
          StyleBox["a",
            FontSlant->"Plain"], " ", \(\@\(a\ b\)\)}], TraditionalForm]]],
  " ni tampoco es cierto en general que Log[Exp[z]] sea igual a z. Puedes \
decir a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " el tipo de variable con el que quieres que trabaje una funci\[OAcute]n de \
la forma que sigue."
}], "Text"],

Cell[BoxData[{
    \(Clear[f]\), 
    \(f[x_Integer] := x^3\ \  (*\ 
      decimos\ a\ Mathematica\ que\ f\ es\ una\ funci\[OAcute]n\ que\ 
        solamente\ puede\ trabajar\ sobre\ n\[UAcute]meros\ enteros\ *) \), 
    \(f[\(-2\)]\), 
    \(f[1/2]\), 
    \(f[\(-2. \)]\  (*\ 
      \(-2. \)\ no\ es\ un\ entero\ para\ Mathematica\ sino\ un\ 
        n\[UAcute]mero\ real\ *) \)}], "Input"],

Cell["\<\
Tambi\[EAcute]n es posible usar el operador de condici\[OAcute]n con los \
argumentos como en el siguiente ejemplo.\
\>", "Text"],

Cell[BoxData[{
    \(g[x_ /; EvenQ[x], y_ /; OddQ[y]] := x*y\ 
    \[IndentingNewLine] (*\ 
      x_ /; EvenQ[x]\ comprueba\ si\ x\ es\ un\ n\[UAcute]mero\ par, \ 
      y_ /; OddQ[y]\ comprueba\ si\ y\ es\ un\ n\[UAcute]mero\ impar\ *) \), 
    \(g[2, 3]\), 
    \(g[3, 2]\), 
    \(Clear[g]\)}], "Input"],

Cell["Otra forma de hacer esto mismo es la siguiente.", "Text"],

Cell[BoxData[{
    RowBox[{\(g[x_?EvenQ, y_?OddQ] := x*y\), " ", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
        RowBox[{
          RowBox[{
          \(x_?EvenQ\), " ", "comprueba", " ", "si", " ", "x", " ", "es", 
            " ", "un", " ", "n\[UAcute]mero", " ", \(par . \ El\), " ", 
            "s\[IAcute]mbolo", " ", 
            StyleBox["_",
              "MR"], 
            StyleBox[" ",
              "MR"], "es", " ", "un", " ", "comod\[IAcute]n", " ", "que", 
            " ", "representa", " ", "calquier", " ", "expresi\[OAcute]n"}], 
          ";", " ", 
          \(?EvenQ\ restringe\ dichas\ expresiones\ a\ las\ que\ dan\  
              "\<True\>"\ cuando\ se\ aplica\ el\ test\ 
              EvenQ . \ An\[AAcute]logamente\ y_?OddQ\ comprueba\ si\ y\ es\ 
              un\ n\[UAcute]mero\ impar\)}], " ", "*)"}]}], \(g[2, 3]\), 
  \(g[3, 2]\), \(Clear[g]\)}], "Input"],

Cell["\<\
Esta forma de proceder se aplica tambi\[EAcute]n para las reglas de sustituci\
\[OAcute]n como muestra el siguiente ejemplo.\
\>", "Text"],

Cell[BoxData[
    RowBox[{
    \({7, \(-9\), 2.4, 3\/5, \[Pi]} /. 
        \[InvisibleSpace]x_?IntegerQ -> x\^2\), "\n", 
      RowBox[{"(*", " ", 
        RowBox[{
        "aplica", " ", "la", " ", "regla", " ", "de", " ", "elevar", " ", 
          "al", " ", "cuadrado", " ", "los", " ", "elementos", " ", "de", 
          " ", "la", " ", "lista", " ", "de", " ", "la", " ", "izquierda", 
          " ", 
          StyleBox["que",
            FontSlant->"Italic"], 
          StyleBox[" ",
            FontSlant->"Italic"], 
          StyleBox["son",
            FontSlant->"Italic"], 
          StyleBox[" ",
            FontSlant->"Italic"], 
          StyleBox["n\[UAcute]meros",
            FontSlant->"Italic"], 
          StyleBox[" ",
            FontSlant->"Italic"], 
          StyleBox["enteros",
            FontSlant->"Italic"]}], " ", "*)"}]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Expresiones", "Section"],

Cell[TextData[{
  "En ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " todo son expresiones. Una expresi\[OAcute]n est\[AAcute] formada por la \
cabeza (",
  StyleBox["Head",
    FontWeight->"Bold"],
  ") de la expresi\[OAcute]n y otros argumentos que a su vez pueden ser \
expresiones. Para entender lo que significa esto vamos a ver la forma en que \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " representa internamente algunos objetos familiares. Para eso usamos el \
comando \"",
  StyleBox["FullForm[expr]",
    FontWeight->"Bold"],
  "\". Procura entender lo que sigue."
}], "Text"],

Cell[BoxData[{
    \(FullForm[a + b]\), 
    \(Head[a + b]\)}], "Input"],

Cell[BoxData[{
    \(FullForm[a*b*c]\), 
    \(Head[a*b*c]\)}], "Input"],

Cell[BoxData[{
    \(FullForm[a^b]\), 
    \(Head[a^b]\)}], "Input"],

Cell[BoxData[{
    \(Head[2]\), 
    \(Head[2. ]\), 
    \(Head[1/2]\)}], "Input"],

Cell[BoxData[{
    \(FullForm[a \[Rule] b]\), 
    \(FullForm[a \[RuleDelayed] b]\)}], "Input"],

Cell[BoxData[{
    \(FullForm[_]\), 
    \(FullForm[x_]\), 
    \(FullForm[x_Real]\)}], "Input"],

Cell["\<\
Ahora puedes entender mejor lo de los patrones o modelos. Por ejemplo, cuando \
aplicas la siguiente regla de sustituci\[OAcute]n:\
\>", "Text"],

Cell[BoxData[
    \(regla = a_^b_ \[Rule] a*b\)], "Input"],

Cell["a una expresi\[OAcute]n como la siguiente", "Text"],

Cell[BoxData[
    \(\@5 + \[Pi]\^3 + 1/\[Pi] + x*y /. regla\)], "Input"],

Cell[TextData[{
  "lo que est\[AAcute]s haciendo es reemplazar por ",
  Cell[BoxData[
      \(TraditionalForm\`a*b\)]],
  " todas las partes de la expresi\[OAcute]n de la izquierda que son de la \
forma:"
}], "Text"],

Cell[BoxData[
    \(\(\(FullForm[a^b]\ \) (*\ 
      donde\ a\ y\ b\ pueden\ ser\ a\ su\ vez\ expresiones\ *) \)\)], "Input"],

Cell["Comprueba:", "Text"],

Cell[BoxData[{
    RowBox[{\(FullForm[\@5]\), " ", 
      RowBox[{"(*", " ", 
        RowBox[{"es", " ", "de", " ", "la", " ", "forma", " ", 
          TagBox[
            StyleBox[\(Power[a, b]\),
              ShowSpecialCharacters->False,
              ShowStringCharacters->True,
              NumberMarks->True],
            FullForm]}], " ", "*)"}]}], 
    RowBox[{\(FullForm[\[Pi]\^3]\), " ", 
      RowBox[{"(*", " ", 
        RowBox[{"es", " ", "de", " ", "la", " ", "forma", " ", 
          TagBox[
            StyleBox[\(Power[a, b]\),
              ShowSpecialCharacters->False,
              ShowStringCharacters->True,
              NumberMarks->True],
            FullForm]}], " ", "*)"}]}], 
    RowBox[{\(FullForm[1/\[Pi]]\), " ", 
      RowBox[{"(*", " ", 
        RowBox[{"es", " ", "de", " ", "la", " ", "forma", " ", 
          TagBox[
            StyleBox[\(Power[a, b]\),
              ShowSpecialCharacters->False,
              ShowStringCharacters->True,
              NumberMarks->True],
            FullForm]}], " ", "*)"}]}], 
    RowBox[{\(FullForm[x*y]\), " ", 
      RowBox[{"(*", " ", 
        RowBox[{"no", " ", "es", " ", "de", " ", "la", " ", "forma", " ", 
          TagBox[
            StyleBox[\(Power[a, b]\),
              ShowSpecialCharacters->False,
              ShowStringCharacters->True,
              NumberMarks->True],
            FullForm]}], " ", "*)"}]}]}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sobre el comando Print[ ]", "Section"],

Cell[TextData[{
  "El comando Print[\"cadena de texto\"] debe usarse ",
  StyleBox["muy poco",
    FontWeight->"Bold"],
  " en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". No olvides que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " saca ",
  StyleBox["todo",
    FontSlant->"Italic"],
  " en pantalla por lo que solamente hay que peocuparse de lo que NO queremos \
que muestre en pantalla (poniendo un ; al final) porque lo consideramos una \
informaci\[OAcute]n innecesaria. Pero hay que evitar usar el comando Print[ ] \
para pedirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que muestre en pantalla lo que el programa ya muestra por s\[IAcute] \
solo. Un inconveniente de Print[ ] es que su salida es considerada siempre \
como una cadena de texto y no puede ser utilizada en ning\[UAcute]n tipo de c\
\[AAcute]lculo num\[EAcute]rico. "
}], "Text"],

Cell[BoxData[{
    \(a = Sin[1.5] (*\ 
      esto\ es\ un\ n\[UAcute]mero\ real\ *) \), "\[IndentingNewLine]", 
    \(b = Print[Sin[1.5]]\  (*\ 
      esto\ no\ es\ un\ n\[UAcute]mero\ *) \), "\[IndentingNewLine]", 
    \(Head[a]\), "\[IndentingNewLine]", 
    \(Head[b]\), "\[IndentingNewLine]", 
    \(a + a\  (*\ se\ puede\ evaluar\ *) \), "\[IndentingNewLine]", 
    \(\(\(a\)\(+\)\(b\)\(\ \)\( (*\ 
        no\ se\ puede\ evaluar\ *) \)\)\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sobre la evaluaci\[OAcute]n de funciones", "Section"],

Cell[TextData[{
  "Las funciones deben definirse en la forma f[x,y] o f[x,y,z], es decir \
deben incluir todas las variables en un corchete, pues de esta forma se \
pueden evaluar directamente. Para evaluar una funci\[OAcute]n, f[x,y] \
correctamente definida, no hay que atribuir valores a las variables porque es \
un trabajo innecesario e inconveniente. Si queremos evaluar f[x,y] en el \
punto (1,2) basta con escribir f[1,2] y ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " mostrar\[AAcute] de forma autom\[AAcute]tica, sin necesidad de que \
nosotros lo pidamos, el resultado en pantalla. "
}], "Text"],

Cell[BoxData[{
    \(\(poli = x\^2*y + y\^3*z + x*y*z\ ;\) (*\ 
      definici\[OAcute]n\ incorrecta\ *) \), "\[IndentingNewLine]", 
    \(\(mismopoli[x_, y_, z_] = 
        x\^2*y + y\^3*z + x*y*z\ ;\)\[IndentingNewLine] (*\ 
      definici\[OAcute]n\ correcta . \ 
          Da\ igual\ aqu\[IAcute]\ que\ usemos\ la\ asignaci\[OAcute]n\ \
inmediata\ o\ la\ diferida . \ El\ ; \ 
      evita\ la\ salida\ en\ pantalla\ *) \), "\[IndentingNewLine]", 
    \(poli /. {x \[Rule] 1, y \[Rule] 2, z -> 3}\  (*\ 
      unica\ forma\ de\ evaluar\ "\<poli\>"\ en\ el\ punto\ \((1, 2, 
          3)\)\ sin\ atribuir\ valores\ a\ las\ variables\ x, \ y, \ z, \ 
      cosa\ que, \ adem\[AAcute]s, \ 
      no\ debemos\ hacer\ pues\ "\<poli\>"\ dejar\[IAcute]a\ de\ ser\ una\ \
funci\[OAcute]n\ y\ pasar\[IAcute]a\ a\ ser\ una\ constante\ hasta\ que\ \
limpi\[AAcute]ramos\ x, \ y, \ 
      z\ con\ un\ Clear[]\ *) \), "\[IndentingNewLine]", 
    \(mismopoli[1, 2, 3]\  (*\ 
      esta\ es\ la\ forma\ correcta\ de\ evaluar . \ No\ debes\ hacer\ x = 
        1, \ y = 2, \ 
      z = 3\ y\ despu\[EAcute]s\ pedir\ a\ Mathematica\ el\ valor\ \
"\<mismopoli[x,y,z]\>"\ porque, \ aunque\ "\<mismopoli\>", \ 
      a\ diferencia\ de\ "\<poli\>", \ 
      seguir\[AAcute]\ siendo\ una\ funci\[OAcute]n, \ 
      las\ atribuciones\ hechas\ para\ x, \ y, \ 
      z\ pueden\ dar\ lugar\ a\ errores\ si\ no\ las\ limpias\ con\ un\ \
Clear[] . \ Demasiado\ trabajo\ innecesario\ *) \)}], "Input"],

Cell["\<\
Cuando definas un comando que deba trabajar sobre funciones has de tener en \
cuenta el tipo de funciones con las que va a trabajar y definirlo de forma \
adecuada. En el siguiente ejemplo se define un comando que calcula la \
divergencia de un campo escalar de tres variables.\
\>", "Text"],

Cell[BoxData[
    \(Clear[divergencia]\)], "Input"],

Cell[BoxData[{
    \(\(\(divergencia[func_]\)[x_, y_, z_] := 
        Module[{u, v, 
            w}, \((D[func[u, v, w], u] + D[func[u, v, w], v] + 
                D[func[u, v, w], w])\) /. {u \[Rule] x, v \[Rule] y, 
              w \[Rule] z}];\)\), "\[IndentingNewLine]", 
    \(\(g[x_, y_, z_] = x\ Sin[x\ y\ z];\)\), "\[IndentingNewLine]", 
    \(\(divergencia[g]\)[x, y, z]\), "\[IndentingNewLine]", 
    \(\(divergencia[g]\)[1, Pi/2, 1] (*\ 
      esta\ es\ la\ forma\ de\ evaluar\ una\ funci\[OAcute]n\ en\ un\ punto, \
\ no\ hay\ que\ hacer\ x = 1, \ y = Pi/2, \ z = 1\ *) \)}], "Input"],

Cell["\<\
Al definir el comando yo s\[EAcute] que le voy a pasar una funci\[OAcute]n de \
tres variables y que la expresi\[OAcute]n \"func[u,v,w]\" que se ha usado al \
definirlo tendr\[AAcute] sentido. El comando no funcionar\[AAcute] si \
\"func\" no est\[AAcute] definida de la forma apropiada. Observa la \
diferencia.\
\>", "Text"],

Cell[BoxData[{
    \(h[{x_, y_, z_}] = x\ Sin[x\ y\ z];  (*\ 
      esta\ funci\[OAcute]n\ no\ est\[AAcute]\ definida\ de\ forma\ \
apropiada, \ 
      no\ es\ igual\ h[{x, y, z}]\ que\ h[x, y, 
          z]\ *) \[IndentingNewLine]\(divergencia[h]\)[x, y, z]\  (*\ 
      no\ la\ calcula\ *) \), "\[IndentingNewLine]", 
    \(D[h[x, y, z], x]\  (*\ 
      h\ no\ puede\ evaluarse\ de\ esta\ forma\ y\ eso\ es\ lo\ que\ intenta\ \
hacer\ el\ comando\ antes\ definido\ *) \), "\[IndentingNewLine]", 
    \(D[h[{x, y, z}], x]\  (*\ 
      esta\ es\ la\ forma\ correcta\ de\ evaluar\ h\ *) \)}], "Input"],

Cell[TextData[{
  "Si quisi\[EAcute]ramos que nuestro comando inicial tambi\[EAcute]n \
trabajara sobre funciones que est\[AAcute]n definidas de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`\(h[{x, y, z}]\  =. \) .. \)]],
  " , podemos a\[NTilde]adir a nuestra definici\[OAcute]n anterior la \
siguiente. F\[IAcute]jate que no hace falta cambiar el nombre del comando."
}], "Text"],

Cell[BoxData[{
    \(\(\(divergencia[{func_}]\)[x_, y_, z_] := 
        Module[{u, v, 
            w}, \((D[func[{u, v, w}], u] + D[func[{u, v, w}], v] + 
                D[func[{u, v, w}], w])\) /. {u \[Rule] x, v \[Rule] y, 
              w \[Rule] z}];\)\), "\[IndentingNewLine]", 
    \(\(divergencia[{h}]\)[x, y, z]\)}], "Input"],

Cell["\<\
Una mejor forma de proceder consiste en usar una funci\[OAcute]n auxiliar que \
transforma una funci\[OAcute]n de la forma h[{x,y,z}] en otra de la forma \
h[x,y,z].\
\>", "Text"],

Cell[BoxData[{
    \(func[{u, v, w}] /. List \[Rule] Sequence\  (*\ 
      sustituye\ la\ cabecera\ List\ de\ {x, y, 
          z}\ por\ Sequence\ *) \), "\[IndentingNewLine]", 
    \(func[u, v, 
        w] /. \(\(List\)\(\[Rule]\)\(Sequence\)\(\ \)\( (*\ 
          lo\ deja\ todo\ igual\ *) \)\)\)}], "Input"],

Cell[BoxData[{
    \(Clear[divergencia]\), "\[IndentingNewLine]", 
    \(\(\(divergencia[func_]\)[x_, y_, z_] := 
        Module[{u, v, w, H}, 
          H[u_, v_, w_] = 
            func[{u, v, w}] /. 
              List \[Rule] Sequence; \((D[H[u, v, w], u] + D[H[u, v, w], v] + 
                D[H[u, v, w], w])\) /. {u \[Rule] x, v \[Rule] y, 
              w \[Rule] z}];\)\)}], "Input"],

Cell["Comprobemos si funciona.", "Text"],

Cell[BoxData[{
    \(\(divergencia[g]\)[x, y, z]\), "\[IndentingNewLine]", 
    \(\(divergencia[h]\)[x, y, z]\ \), "\[IndentingNewLine]", 
    \(\(divergencia[g]\)[1, Pi/2, 1]\), "\[IndentingNewLine]", 
    \(\(divergencia[h]\)[1, Pi/2, 1]\ \)}], "Input"],

Cell[TextData[{
  "En resumen, cuando se define un comando que debe usar funciones hay que \
definir el comando teniendo en cuenta c\[OAcute]mo se eval\[UAcute]a el tipo \
de funciones que se van a usar. Muchas veces el tipo de funci\[OAcute]n \
depende de la forma en que queremos evaluarla. Por ejemplo, una \
funci\[OAcute]n que pueda evaluarse en pares de puntos de la forma {{x,y},z} \
deber\[AAcute] definirse como ",
  Cell[BoxData[
      \(TraditionalForm\`func[{{x_, y_}, z_}] :=  ... \)]],
  " Cualquier comando al que se le pase dicha funci\[OAcute]n deber\[AAcute] \
definirse teniendo en cuenta la forma en que se eval\[UAcute]a la misma."
}], "Text"]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, 2},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ 
        "Asignaci\[OAcute]n Diferida. Listas y reglas de sustituci\[OAcute]n\n\
LOcalizaci\[OAcute]n de variables. Primitivas gr\[AAcute]ficasd"], 
        "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ 
        "Asignaci\[OAcute]n diferida. Listas y reglas de sustituci\[OAcute]n\n\
Localizaci\[OAcute]n de variables. Primitivas gr\[AAcute]ficas"], 
        "Header"]}},
Magnification->1.25,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "b:16"->{
    Cell[63381, 1908, 624, 11, 231, "Input",
      CellTags->{"b:16", "IPM3.4.6.1"}]},
  "IPM3.4.6.1"->{
    Cell[63381, 1908, 624, 11, 231, "Input",
      CellTags->{"b:16", "IPM3.4.6.1"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"b:16", 96958, 2787},
  {"IPM3.4.6.1", 97063, 2790}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 263, 4, 116, "Title"],
Cell[2020, 57, 187, 6, 90, "Author"],

Cell[CellGroupData[{
Cell[2232, 67, 221, 8, 77, "Section"],
Cell[2456, 77, 2322, 84, 165, "Text"],
Cell[4781, 163, 81, 3, 102, "Input"],
Cell[4865, 168, 246, 4, 54, "Text"],
Cell[5114, 174, 54, 1, 60, "Input"],
Cell[5171, 177, 43, 1, 60, "Input"],
Cell[5217, 180, 407, 7, 75, "Text"],
Cell[5627, 189, 55, 1, 60, "Input"],
Cell[5685, 192, 66, 2, 81, "Input"],
Cell[5754, 196, 549, 13, 75, "Text"],
Cell[6306, 211, 272, 5, 54, "Text"],
Cell[6581, 218, 173, 4, 81, "Input"],
Cell[6757, 224, 456, 11, 54, "Text"],
Cell[7216, 237, 87, 3, 102, "Input"],
Cell[7306, 242, 181, 4, 33, "Text"],
Cell[7490, 248, 282, 5, 54, "Text"],
Cell[7775, 255, 280, 6, 54, "Text"],
Cell[8058, 263, 212, 5, 123, "Input"],
Cell[8273, 270, 562, 14, 75, "Text"],
Cell[8838, 286, 123, 4, 123, "Input"],
Cell[8964, 292, 1215, 34, 98, "Text"],
Cell[10182, 328, 118, 3, 123, "Input"],
Cell[10303, 333, 220, 6, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10560, 344, 25, 0, 77, "Section"],
Cell[10588, 346, 413, 9, 54, "Text"],
Cell[11004, 357, 87, 1, 60, "Input"],
Cell[11094, 360, 91, 2, 33, "Text"],
Cell[11188, 364, 49, 1, 60, "Input"],
Cell[11240, 367, 116, 3, 33, "Text"],
Cell[11359, 372, 996, 18, 285, "Text"],
Cell[12358, 392, 306, 9, 228, "Input"],
Cell[12667, 403, 154, 3, 33, "Text"],
Cell[12824, 408, 358, 6, 123, "Input"],
Cell[13185, 416, 242, 6, 33, "Text"],
Cell[13430, 424, 145, 4, 123, "Input"],
Cell[13578, 430, 252, 6, 33, "Text"],
Cell[13833, 438, 197, 4, 123, "Input"],
Cell[14033, 444, 175, 3, 33, "Text"],
Cell[14211, 449, 268, 5, 81, "Input"],
Cell[14482, 456, 131, 3, 33, "Text"],
Cell[14616, 461, 267, 5, 102, "Input"],
Cell[14886, 468, 191, 5, 33, "Text"],
Cell[15080, 475, 119, 2, 60, "Input"],
Cell[15202, 479, 107, 3, 33, "Text"],
Cell[15312, 484, 94, 2, 81, "Input"],
Cell[15409, 488, 144, 3, 33, "Text"],
Cell[15556, 493, 139, 2, 60, "Input"],
Cell[15698, 497, 54, 0, 33, "Text"],
Cell[15755, 499, 157, 3, 60, "Input"],
Cell[15915, 504, 224, 4, 54, "Text"],
Cell[16142, 510, 288, 5, 123, "Input"],
Cell[16433, 517, 517, 8, 75, "Text"],
Cell[16953, 527, 70, 1, 60, "Input"],
Cell[17026, 530, 46, 1, 60, "Input"],
Cell[17075, 533, 42, 1, 60, "Input"],
Cell[17120, 536, 46, 1, 60, "Input"],
Cell[17169, 539, 38, 0, 33, "Text"],
Cell[17210, 541, 282, 5, 123, "Input"],
Cell[17495, 548, 119, 3, 33, "Text"],
Cell[17617, 553, 164, 2, 81, "Input"],
Cell[17784, 557, 219, 4, 54, "Text"],
Cell[18006, 563, 46, 1, 60, "Input"],
Cell[18055, 566, 404, 6, 75, "Text"],
Cell[18462, 574, 97, 2, 33, "Text"],
Cell[18562, 578, 57, 1, 60, "Input"],
Cell[18622, 581, 219, 4, 54, "Text"],
Cell[18844, 587, 45, 1, 60, "Input"],
Cell[18892, 590, 48, 1, 60, "Input"],
Cell[18943, 593, 78, 1, 60, "Input"],
Cell[19024, 596, 285, 5, 54, "Text"],
Cell[19312, 603, 497, 9, 165, "Input"],
Cell[19812, 614, 66, 1, 60, "Input"],
Cell[19881, 617, 602, 11, 75, "Text"],
Cell[20486, 630, 104, 2, 81, "Input"],
Cell[20593, 634, 360, 6, 144, "Input"],
Cell[20956, 642, 847, 19, 96, "Text"],
Cell[21806, 663, 656, 11, 186, "Input"],
Cell[22465, 676, 180, 4, 33, "Text"],
Cell[22648, 682, 431, 8, 144, "Input"],
Cell[23082, 692, 146, 3, 33, "Text"],
Cell[23231, 697, 160, 4, 123, "Input"],
Cell[23394, 703, 143, 3, 33, "Text"],
Cell[23540, 708, 377, 7, 123, "Input"],
Cell[23920, 717, 384, 7, 144, "Input"],
Cell[24307, 726, 434, 7, 75, "Text"],
Cell[24744, 735, 168, 3, 102, "Input"],
Cell[24915, 740, 158, 3, 33, "Text"],
Cell[25076, 745, 83, 1, 60, "Input"],
Cell[25162, 748, 608, 11, 75, "Text"],
Cell[25773, 761, 114, 2, 82, "Input"],
Cell[25890, 765, 203, 4, 33, "Text"],
Cell[26096, 771, 251, 5, 102, "Input"],
Cell[26350, 778, 229, 4, 54, "Text"],
Cell[26582, 784, 235, 5, 123, "Input"],
Cell[26820, 791, 563, 9, 75, "Text"],
Cell[27386, 802, 497, 9, 102, "Input"],
Cell[27886, 813, 237, 4, 54, "Text"],
Cell[28126, 819, 343, 7, 102, "Input"],
Cell[28472, 828, 170, 5, 33, "Text"],
Cell[28645, 835, 89, 2, 33, "Text"],
Cell[28737, 839, 168, 2, 81, "Input"],
Cell[28908, 843, 152, 3, 33, "Text"],
Cell[29063, 848, 526, 10, 144, "Input"],
Cell[29592, 860, 68, 0, 33, "Text"],
Cell[29663, 862, 53, 1, 60, "Input"],
Cell[29719, 865, 325, 7, 54, "Text"],
Cell[30047, 874, 110, 2, 81, "Input"],
Cell[30160, 878, 66, 1, 60, "Input"],
Cell[30229, 881, 45, 1, 60, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30311, 887, 133, 3, 77, "Section"],
Cell[30447, 892, 320, 5, 54, "Text"],
Cell[30770, 899, 198, 4, 81, "Input"],
Cell[30971, 905, 138, 3, 33, "Text"],
Cell[31112, 910, 109, 2, 81, "Input"],
Cell[31224, 914, 2140, 73, 143, "Text"],
Cell[33367, 989, 418, 7, 144, "Input"],
Cell[33788, 998, 103, 2, 60, "Input"],
Cell[33894, 1002, 325, 11, 34, "Text"],
Cell[34222, 1015, 56, 1, 60, "Input"],
Cell[34281, 1018, 430, 9, 81, "Input"],
Cell[34714, 1029, 296, 8, 56, "Text"],
Cell[35013, 1039, 105, 2, 61, "Input"],
Cell[35121, 1043, 403, 10, 55, "Text"],
Cell[35527, 1055, 106, 2, 61, "Input"],
Cell[35636, 1059, 711, 27, 58, "Text"],
Cell[36350, 1088, 261, 5, 54, "Text"],
Cell[36614, 1095, 108, 2, 61, "Input"],
Cell[36725, 1099, 581, 12, 76, "Text"],
Cell[37309, 1113, 167, 3, 33, "Text"],
Cell[37479, 1118, 90, 1, 60, "Input"],
Cell[37572, 1121, 499, 9, 144, "Input"],
Cell[38074, 1132, 837, 26, 77, "Text"],
Cell[38914, 1160, 227, 4, 102, "Input"],
Cell[39144, 1166, 333, 6, 102, "Input"],
Cell[39480, 1174, 3373, 107, 120, "Text"],
Cell[42856, 1283, 289, 5, 118, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[43182, 1293, 54, 0, 77, "Section"],
Cell[43239, 1295, 77, 0, 33, "Text"],
Cell[43319, 1297, 54, 1, 60, "Input"],
Cell[43376, 1300, 222, 4, 83, "Input"],
Cell[43601, 1306, 73, 0, 33, "Text"],
Cell[43677, 1308, 75, 1, 60, "Input"],
Cell[43755, 1311, 448, 10, 54, "Text"],
Cell[44206, 1323, 69, 1, 60, "Input"],
Cell[44278, 1326, 139, 3, 33, "Text"],
Cell[44420, 1331, 198, 3, 81, "Input"],
Cell[44621, 1336, 73, 0, 33, "Text"],
Cell[44697, 1338, 229, 4, 102, "Input"],
Cell[44929, 1344, 93, 2, 33, "Text"],
Cell[45025, 1348, 229, 4, 102, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[45291, 1357, 57, 0, 77, "Section"],
Cell[45351, 1359, 526, 13, 75, "Text"],
Cell[45880, 1374, 53, 1, 81, "Input"],
Cell[45936, 1377, 1322, 43, 97, "Text"],
Cell[47261, 1422, 455, 12, 60, "Input"],
Cell[47719, 1436, 145, 3, 60, "Input"],
Cell[47867, 1441, 122, 3, 33, "Text"],
Cell[47992, 1446, 268, 5, 102, "Input"],
Cell[48263, 1453, 39, 1, 60, "Input"],
Cell[48305, 1456, 497, 10, 75, "Text"],
Cell[48805, 1468, 172, 3, 33, "Text"],
Cell[48980, 1473, 321, 7, 186, "Input"],
Cell[49304, 1482, 207, 4, 54, "Text"],
Cell[49514, 1488, 124, 2, 60, "Input"],
Cell[49641, 1492, 510, 10, 75, "Text"],
Cell[50154, 1504, 96, 2, 82, "Input"],
Cell[50253, 1508, 51, 0, 33, "Text"],
Cell[50307, 1510, 74, 2, 81, "Input"],
Cell[50384, 1514, 493, 9, 75, "Text"],
Cell[50880, 1525, 217, 5, 102, "Input"],
Cell[51100, 1532, 127, 3, 103, "Input"],
Cell[51230, 1537, 214, 4, 54, "Text"],
Cell[51447, 1543, 929, 17, 228, "Input"],
Cell[52379, 1562, 353, 8, 54, "Text"],
Cell[52735, 1572, 44, 1, 60, "Input"],
Cell[52782, 1575, 359, 8, 54, "Text"],
Cell[53144, 1585, 279, 6, 123, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[53460, 1596, 56, 0, 77, "Section"],
Cell[53519, 1598, 630, 11, 96, "Text"],
Cell[54152, 1611, 510, 8, 144, "Input"],
Cell[54665, 1621, 60, 1, 60, "Input"],
Cell[54728, 1624, 116, 2, 60, "Input"],
Cell[54847, 1628, 66, 1, 60, "Input"],
Cell[54916, 1631, 264, 7, 55, "Text"],
Cell[55183, 1640, 84, 1, 60, "Input"],
Cell[55270, 1643, 90, 1, 60, "Input"],
Cell[55363, 1646, 108, 3, 34, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[55508, 1654, 59, 0, 77, "Section"],
Cell[55570, 1656, 460, 9, 109, "Text"],
Cell[56033, 1667, 92, 1, 60, "Input"],
Cell[56128, 1670, 273, 5, 55, "Text"],
Cell[56404, 1677, 52, 1, 60, "Input"],
Cell[56459, 1680, 267, 5, 55, "Text"],
Cell[56729, 1687, 124, 2, 81, "Input"],
Cell[56856, 1691, 59, 0, 34, "Text"],
Cell[56918, 1693, 240, 5, 125, "Input"],
Cell[57161, 1700, 366, 6, 77, "Text"],
Cell[57530, 1708, 260, 6, 103, "Input"],
Cell[57793, 1716, 57, 1, 60, "Input"],
Cell[57853, 1719, 189, 4, 81, "Input"],
Cell[58045, 1725, 238, 6, 55, "Text"],
Cell[58286, 1733, 455, 9, 125, "Input"],
Cell[58744, 1744, 38, 0, 34, "Text"],
Cell[58785, 1746, 114, 2, 81, "Input"],
Cell[58902, 1750, 54, 0, 34, "Text"],
Cell[58959, 1752, 174, 3, 103, "Input"],
Cell[59136, 1757, 157, 3, 34, "Text"],
Cell[59296, 1762, 511, 11, 168, "Input"],
Cell[59810, 1775, 56, 0, 34, "Text"],
Cell[59869, 1777, 59, 1, 60, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[59965, 1783, 49, 0, 77, "Section"],
Cell[60017, 1785, 3361, 121, 317, "Text"],
Cell[63381, 1908, 624, 11, 231, "Input",
  CellTags->{"b:16", "IPM3.4.6.1"}],
Cell[64008, 1921, 217, 5, 34, "Text"],
Cell[64228, 1928, 133, 2, 60, "Input"],
Cell[64364, 1932, 47, 1, 60, "Input"],
Cell[64414, 1935, 982, 19, 190, "Input"],
Cell[65399, 1956, 108, 3, 34, "Text"],
Cell[65510, 1961, 430, 10, 146, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[65977, 1976, 46, 0, 77, "Section"],
Cell[66026, 1978, 364, 10, 55, "Text"],
Cell[66393, 1990, 134, 2, 60, "Input"],
Cell[66530, 1994, 622, 13, 77, "Text"],
Cell[67155, 2009, 141, 3, 60, "Input"],
Cell[67299, 2014, 96, 2, 34, "Text"],
Cell[67398, 2018, 122, 2, 34, "Text"],
Cell[67523, 2022, 223, 5, 55, "Text"],
Cell[67749, 2029, 100, 2, 34, "Text"],
Cell[67852, 2033, 2216, 38, 337, "Text"],
Cell[70071, 2073, 239, 6, 103, "Input"],
Cell[70313, 2081, 2972, 76, 265, "Text"],
Cell[73288, 2159, 1585, 36, 298, "Input"],
Cell[74876, 2197, 239, 5, 103, "Input"],
Cell[75118, 2204, 208, 3, 55, "Text"],
Cell[75329, 2209, 50, 1, 60, "Input"],
Cell[75382, 2212, 129, 2, 60, "Input"],
Cell[75514, 2216, 207, 4, 55, "Text"],
Cell[75724, 2222, 557, 12, 168, "Input"],
Cell[76284, 2236, 269, 5, 55, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[76590, 2246, 47, 0, 77, "Section"],
Cell[76640, 2248, 625, 9, 99, "Text"],
Cell[77268, 2259, 534, 10, 168, "Input"],
Cell[77805, 2271, 546, 10, 190, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[78388, 2286, 42, 0, 77, "Section"],
Cell[78433, 2288, 954, 25, 120, "Text"],
Cell[79390, 2315, 221, 7, 190, "Input"],
Cell[79614, 2324, 29, 0, 34, "Text"],
Cell[79646, 2326, 397, 10, 168, "Input"],
Cell[80046, 2338, 1012, 23, 120, "Text"],
Cell[81061, 2363, 392, 9, 190, "Input"],
Cell[81456, 2374, 139, 3, 34, "Text"],
Cell[81598, 2379, 306, 7, 168, "Input"],
Cell[81907, 2388, 63, 0, 34, "Text"],
Cell[81973, 2390, 903, 18, 233, "Input"],
Cell[82879, 2410, 148, 3, 34, "Text"],
Cell[83030, 2415, 869, 23, 125, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[83936, 2443, 30, 0, 77, "Section"],
Cell[83969, 2445, 612, 18, 77, "Text"],
Cell[84584, 2465, 72, 2, 81, "Input"],
Cell[84659, 2469, 72, 2, 81, "Input"],
Cell[84734, 2473, 68, 2, 81, "Input"],
Cell[84805, 2477, 82, 3, 103, "Input"],
Cell[84890, 2482, 95, 2, 81, "Input"],
Cell[84988, 2486, 96, 3, 103, "Input"],
Cell[85087, 2491, 154, 3, 34, "Text"],
Cell[85244, 2496, 58, 1, 60, "Input"],
Cell[85305, 2499, 57, 0, 34, "Text"],
Cell[85365, 2501, 72, 1, 64, "Input"],
Cell[85440, 2504, 216, 6, 34, "Text"],
Cell[85659, 2512, 125, 2, 60, "Input"],
Cell[85787, 2516, 26, 0, 34, "Text"],
Cell[85816, 2518, 1420, 36, 131, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[87273, 2559, 44, 0, 77, "Section"],
Cell[87320, 2561, 899, 23, 120, "Text"],
Cell[88222, 2586, 457, 9, 168, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[88716, 2600, 59, 0, 77, "Section"],
Cell[88778, 2602, 620, 11, 99, "Text"],
Cell[89401, 2615, 1476, 26, 385, "Input"],
Cell[90880, 2643, 301, 5, 77, "Text"],
Cell[91184, 2650, 51, 1, 60, "Input"],
Cell[91238, 2653, 597, 10, 233, "Input"],
Cell[91838, 2665, 336, 6, 55, "Text"],
Cell[92177, 2673, 600, 11, 211, "Input"],
Cell[92780, 2686, 389, 7, 55, "Text"],
Cell[93172, 2695, 334, 6, 146, "Input"],
Cell[93509, 2703, 189, 4, 55, "Text"],
Cell[93701, 2709, 311, 6, 103, "Input"],
Cell[94015, 2717, 393, 8, 125, "Input"],
Cell[94411, 2727, 40, 0, 34, "Text"],
Cell[94454, 2729, 255, 4, 125, "Input"],
Cell[94712, 2735, 664, 11, 120, "Text"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

